/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world;

import com.badlogic.gdx.files.FileHandle;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.DataContext;
import com.neutronio.astrax.app.Factory;
import com.neutronio.astrax.app.datapack.DataPack;
import com.neutronio.astrax.app.datapack.GameSessionFactory;
import com.neutronio.astrax.app.datapack.game.DiscoveryFactory;
import com.neutronio.astrax.app.datapack.game.Game;
import com.neutronio.astrax.app.datapack.game.GameLogic;
import com.neutronio.astrax.app.datapack.game.mechanics.resources.ResourceCollectionManager;
import com.neutronio.astrax.app.datapack.game.world.GalaxyMapContext;
import com.neutronio.astrax.app.datapack.game.world.PlayerFactory;
import com.neutronio.astrax.app.datapack.game.world.SatelliteTarget;
import com.neutronio.astrax.app.datapack.game.world.SpawnManager;
import com.neutronio.astrax.app.datapack.game.world.World;
import com.neutronio.astrax.app.datapack.game.world.WorldSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.Galaxy;
import com.neutronio.astrax.app.datapack.game.world.galaxy.GalaxyFactory;
import com.neutronio.astrax.app.datapack.game.world.galaxy.GalaxyRegionFactory;
import com.neutronio.astrax.app.datapack.game.world.galaxy.StarSystemSectorFactory;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.docking.Docking;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.DiscoverySystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.StarSystemFactory;
import com.neutronio.astrax.app.generator.AbstractFactory;
import com.neutronio.astrax.app.main.SavedGame;
import com.neutronio.astrax.io.FileHandler;
import com.neutronio.astrax.io.sql.AsteroidDAO;
import com.neutronio.astrax.io.sql.DiscoveryDAO;
import com.neutronio.astrax.io.sql.GalaxyRegionDAO;
import com.neutronio.astrax.io.sql.GameDatabase;
import com.neutronio.astrax.io.sql.MerchantDAO;
import com.neutronio.astrax.io.sql.NavigationBookmarkDAO;
import com.neutronio.astrax.io.sql.SatelliteDAO;
import com.neutronio.astrax.io.sql.StarSystemHeaderDAO;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WorldFactory
extends AbstractFactory {
    private static List<Class<? extends GameLogic>> defaultGameLogic = new ArrayList<Class<? extends GameLogic>>();
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private GalaxyFactory galaxyFactory;
    private PlayerFactory playerFactory;
    private StarSystemFactory starSystemFactory;

    public WorldFactory() {
        this.galaxyFactory = AstraXApp.astraX.getFactoryByClass(GalaxyFactory.class);
        this.playerFactory = AstraXApp.astraX.getFactoryByClass(PlayerFactory.class);
        this.starSystemFactory = AstraXApp.astraX.getFactoryByClass(StarSystemFactory.class);
    }

    public WorldFactory(DataContext dataContext) {
        super(dataContext);
        this.galaxyFactory = dataContext.getFactory(GalaxyFactory.class);
        this.playerFactory = dataContext.getFactory(PlayerFactory.class);
        this.starSystemFactory = dataContext.getFactory(StarSystemFactory.class);
    }

    public World create(Game game, WorldSettings worldSettings) {
        this.logger.log(Level.INFO, "Creating new world...");
        this.logger.log(Level.FINEST, "Seeding factories...");
        Random seeder = new Random(game.getSeed());
        Collection<Factory> factories = AstraXApp.astraX.getAllLoadedFactories();
        for (Factory factory : factories) {
            if (!(factory instanceof AbstractFactory)) continue;
            ((AbstractFactory)factory).setSeed(seeder.nextLong());
        }
        this.logger.log(Level.FINEST, "Creating galaxy context...");
        World world = new World();
        GalaxyMapContext galaxyMapContext = this.newGalaxyMapContext(game.getGameDirectory(), worldSettings.getGalaxySettings().galaxyName, true);
        world.setGalaxyMapContext(galaxyMapContext);
        SpawnManager spawnManager = new SpawnManager(galaxyMapContext, world);
        world.setSpawnManager(spawnManager);
        this.dataContext.getFactory(GameSessionFactory.class).setGalaxyMapContext(galaxyMapContext);
        this.logger.log(Level.FINEST, "Creating galaxy...");
        this.galaxyFactory.setSeed(seeder.nextLong());
        Galaxy galaxy = this.galaxyFactory.createGalaxy(worldSettings.getGalaxySettings());
        world.setGalaxy(galaxy);
        FileHandler.State state = AstraXApp.astraX.getAstraXFiles().saveFileBinary((Serializable)galaxy, galaxy.getName() + ".dat", game.getGameDirectory());
        this.logger.log(Level.INFO, "Saving Galaxy: " + (Object)((Object)state));
        this.logger.log(Level.INFO, "Theoretical amount of galaxies for this galaxy: " + galaxy.getTheoreticalAmountOfSystems());
        this.logger.log(Level.FINEST, "Creating starter region...");
        this.galaxyFactory.createStarterRegion(galaxy);
        this.instantiateGameLogic(world, defaultGameLogic);
        this.starSystemFactory.setGalaxyDistributionSettings(galaxy.getGalaxySettings().galaxyDistributionSettings);
        return world;
    }

    public World load(SavedGame savedGame, Game game) {
        this.logger.log(Level.INFO, "Loading world...");
        World world = new World();
        GalaxyMapContext galaxyMapContext = this.newGalaxyMapContext(game.getGameDirectory(), savedGame.currentGalaxyName, false);
        SpawnManager spawnManager = new SpawnManager(galaxyMapContext, world);
        world.setGalaxyMapContext(galaxyMapContext);
        world.setSpawnManager(spawnManager);
        this.dataContext.getFactory(GameSessionFactory.class).setGalaxyMapContext(galaxyMapContext);
        Galaxy galaxy = this.galaxyFactory.loadGalaxy(savedGame.currentGalaxyName, game.getGameDirectory());
        world.setGalaxy(galaxy);
        this.starSystemFactory.setGalaxyDistributionSettings(galaxy.getGalaxySettings().galaxyDistributionSettings);
        this.instantiateGameLogic(world, defaultGameLogic);
        return world;
    }

    public SatelliteTarget loadPlayerSpacecraft(World world) {
        SatelliteTarget playerTarget = null;
        try {
            playerTarget = world.getSpawnManager().loadAndSpawnSatellite(1);
            this.playerFactory.initPlayerSatellite(playerTarget);
            world.getLocalPlayer().setPlayerTarget(playerTarget);
            ((Satellite)playerTarget.getModel()).getSystem(DiscoverySystem.class).getScanner().setGalaxyMapContext(world.getGalaxyMapContext());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return playerTarget;
    }

    private void instantiateGameLogic(World world, List<Class<? extends GameLogic>> gameLogicList) {
        this.logger.log(Level.INFO, "Instantiating Game Logic Objects...");
        for (Class<? extends GameLogic> gameLogicClass : gameLogicList) {
            try {
                Constructor<? extends GameLogic> constructor = gameLogicClass.getDeclaredConstructor(DataPack.class);
                GameLogic gameLogic = constructor.newInstance(this.dataPack);
                world.addGameLogic(gameLogic);
                gameLogic.setParentWorld(world);
                this.logger.log(Level.INFO, "..." + gameLogicClass.getCanonicalName());
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                this.logger.log(Level.WARNING, "Could not instantiate GameLogic Object", e);
            }
        }
    }

    public GalaxyMapContext newGalaxyMapContext(FileHandle gameDirectory, String galaxyName, boolean create) {
        this.logger.log(Level.INFO, "Create Galaxy Map Context...");
        GalaxyMapContext galaxyMapContext = new GalaxyMapContext();
        this.logger.log(Level.FINEST, "... Creating directory and database for world");
        FileHandle databaseFile = gameDirectory.child(galaxyName + ".db");
        GameDatabase database = new GameDatabase("jdbc:sqlite:" + databaseFile.file().getAbsolutePath());
        database = new GameDatabase("jdbc:sqlite:" + databaseFile.file().getAbsolutePath());
        database.openConnection();
        if (create) {
            database.createTables();
        }
        galaxyMapContext.setDatabase(database);
        this.logger.log(Level.FINEST, "... Instantiating DAOs");
        galaxyMapContext.galaxyRegionDAO = new GalaxyRegionDAO(database);
        galaxyMapContext.starSystemHeaderDAO = new StarSystemHeaderDAO(database);
        galaxyMapContext.satelliteDAO = new SatelliteDAO(database);
        galaxyMapContext.asteroidDAO = new AsteroidDAO(database);
        galaxyMapContext.discoveryDAO = new DiscoveryDAO(database);
        galaxyMapContext.navigationBookmarkDAO = new NavigationBookmarkDAO(database);
        galaxyMapContext.merchantDAO = new MerchantDAO(database);
        this.logger.log(Level.FINEST, "... Instantiating Map Factories");
        galaxyMapContext.galaxyFactory = AstraXApp.astraX.getFactoryByClass(GalaxyFactory.class);
        galaxyMapContext.galaxyFactory.setGalaxyMapContext(galaxyMapContext);
        galaxyMapContext.starSystemFactory = AstraXApp.astraX.getFactoryByClass(StarSystemFactory.class);
        galaxyMapContext.starSystemFactory.setGalaxyMapContext(galaxyMapContext);
        galaxyMapContext.discoveryFactory = AstraXApp.astraX.getFactoryByClass(DiscoveryFactory.class);
        galaxyMapContext.starSystemSectorFactory = AstraXApp.astraX.getFactoryByClass(StarSystemSectorFactory.class);
        galaxyMapContext.starSystemSectorFactory.setGalaxyMapContext(galaxyMapContext);
        galaxyMapContext.galaxyRegionFactory = AstraXApp.astraX.getFactoryByClass(GalaxyRegionFactory.class);
        galaxyMapContext.galaxyRegionFactory.setGalaxyMapContext(galaxyMapContext);
        return galaxyMapContext;
    }

    static {
        defaultGameLogic.add(Docking.class);
        defaultGameLogic.add(ResourceCollectionManager.class);
    }
}

