/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.neutronio.astrax.app.datapack.EntityID;
import com.neutronio.astrax.app.datapack.game.world.galaxy.GalaxyRegion;
import com.neutronio.astrax.app.datapack.game.world.galaxy.GalaxySettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.StarSystemHeader;
import com.neutronio.astrax.util.collections.Grid;
import com.neutronio.astrax.util.collections.IndexedGrid;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Random;
import java.util.logging.Logger;

public class Galaxy
implements Serializable {
    private static final long serialVersionUID = -2905717179697975590L;
    private static Logger logger = Logger.getLogger(Galaxy.class.getSimpleName());
    private long seed;
    private int regionSeed;
    private EntityID id;
    private int tileID;
    private int regionID;
    private String name;
    private String textureRegionName;
    private int theoreticalAmountOfSystems = 0;
    private GalaxySettings galaxySettings;
    private transient IndexedGrid<GalaxyRegion> cachedRegions;
    private transient Grid<StarSystemHeader> starSystemData;
    private Grid<SectorProperty> densityData;

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
        this.regionSeed = new Random(seed).nextInt();
    }

    public String getTextureRegionName() {
        return this.textureRegionName;
    }

    public int getNewTileID() {
        return ++this.tileID;
    }

    public int getRegionSeed() {
        return this.regionSeed;
    }

    public int getWidth() {
        return this.densityData.getWidth();
    }

    public int getHeight() {
        return this.densityData.getHeight();
    }

    public EntityID getId() {
        return this.id;
    }

    public void setId(EntityID id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addRegionToCache(GalaxyRegion region, int localX, int localY) {
        this.cachedRegions.registerTile(region, (short)region.id);
        this.cachedRegions.putTile((short)region.id, localX, localY);
    }

    public GalaxyRegion getCachedRegion(int localX, int localY) {
        return this.cachedRegions.getByLocalCoordinates(localX, localY);
    }

    public void markForRegionCollision(int localX, int localY, Integer regionSeed) {
        SectorProperty sector = this.densityData.get(localX, localY);
        if (sector != null) {
            sector.regionSeed = regionSeed;
        }
    }

    public boolean isFreeForRegionCollision(int localX, int localY) {
        if (!this.densityData.isInBounds(localX, localY)) {
            return false;
        }
        return this.densityData.get((int)localX, (int)localY).regionSeed == null;
    }

    public void addStarSystemHeader(StarSystemHeader starSystemHeader, int localX, int localY) {
        this.starSystemData.place(localX, localY, starSystemHeader);
    }

    public StarSystemHeader getStarSystemHeader(int localX, int localY) {
        return this.starSystemData.get(localX, localY);
    }

    public SectorProperty getSector(int x, int y) {
        return this.densityData.get(x, y);
    }

    public void initByTexture(TextureRegion region) {
        this.textureRegionName = ((TextureAtlas.AtlasRegion)region).name;
        this.theoreticalAmountOfSystems = 0;
        this.densityData = new Grid(region.getRegionWidth(), region.getRegionHeight());
        this.starSystemData = new Grid(region.getRegionWidth(), region.getRegionHeight());
        this.cachedRegions = new IndexedGrid(region.getRegionWidth(), region.getRegionHeight());
        float brightness = 2.4f;
        Texture texture = region.getTexture();
        if (!texture.getTextureData().isPrepared()) {
            texture.getTextureData().prepare();
        }
        Color currentColor = new Color();
        Pixmap image = region.getTexture().getTextureData().consumePixmap();
        logger.fine("Galaxy Seed: " + this.getSeed());
        logger.finest("Galaxy dimensions: " + this.getWidth() + " x " + this.getHeight() + " area: " + this.getWidth() * this.getHeight());
        int sectorSeed = new Random(this.seed).nextInt();
        for (int x = 0; x < this.densityData.getWidth(); ++x) {
            for (int y = 0; y < this.densityData.getHeight(); ++y) {
                currentColor.set(image.getPixel(region.getRegionX() + x, region.getRegionY() + y));
                float density = MathUtils.clamp((currentColor.r + currentColor.g + currentColor.b) / 3.0f * brightness, 0.0f, 1.0f);
                this.densityData.place(x, y, new SectorProperty(currentColor.cpy(), density, new Random(sectorSeed).nextInt()));
                if ((double)density > Math.random()) {
                    ++this.theoreticalAmountOfSystems;
                }
                ++sectorSeed;
            }
        }
        image.dispose();
    }

    public SectorProperty getSectorPropertybyLocalCoordinates(int x, int y) {
        return this.densityData.get(x, y);
    }

    public float getDensity(int x, int y) {
        return this.densityData.get((int)(x + this.getWidth() / 2), (int)(y + this.getHeight() / 2)).density;
    }

    public float getDensitybyLocalCoordinates(int x, int y) {
        return this.densityData.get((int)x, (int)y).density;
    }

    public GalaxySettings getGalaxySettings() {
        return this.galaxySettings;
    }

    public void setGalaxySettings(GalaxySettings galaxySettings) {
        this.galaxySettings = galaxySettings;
    }

    public int getTheoreticalAmountOfSystems() {
        return this.theoreticalAmountOfSystems;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeUTF(this.name);
        oos.writeUTF(this.textureRegionName);
        oos.writeLong(this.seed);
        oos.writeInt(this.tileID);
        oos.writeInt(this.regionID);
        oos.writeInt(this.theoreticalAmountOfSystems);
        oos.writeObject(this.galaxySettings);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        this.name = ois.readUTF();
        this.textureRegionName = ois.readUTF();
        this.seed = ois.readLong();
        this.regionSeed = new Random(this.seed).nextInt();
        this.tileID = ois.readInt();
        this.regionID = ois.readInt();
        this.theoreticalAmountOfSystems = ois.readInt();
        this.galaxySettings = (GalaxySettings)ois.readObject();
    }

    public String toString() {
        return "Galaxy{id=" + this.id + ", name='" + this.name + '\'' + ", theoreticalAmountOfSystems='" + this.theoreticalAmountOfSystems + '\'' + '}';
    }

    public void dispose() {
        this.cachedRegions.clear();
        this.starSystemData.clear();
        this.densityData.clear();
    }

    public class SectorProperty
    implements Serializable {
        private static final long serialVersionUID = -456456578697975590L;
        public Color color;
        public float density;
        public int seed;
        public Integer regionSeed = null;

        public SectorProperty(Color color, float density, int seed) {
            this.color = color;
            this.density = density;
            this.seed = seed;
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            oos.writeObject(this.seed);
            oos.writeObject(this.regionSeed);
            oos.writeObject(Float.valueOf(this.density));
            oos.writeObject(Color.rgba8888(this.color));
        }

        private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
            this.seed = (Integer)ois.readObject();
            this.regionSeed = (int)((Integer)ois.readObject());
            this.density = ((Float)ois.readObject()).floatValue();
            this.color = new Color((Integer)ois.readObject());
        }
    }
}

