/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy;

import com.neutronio.astrax.app.CreationSettings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class GalaxyDistributionSettings
implements CreationSettings,
Serializable {
    private Map<String, Float> distributionParameters = new LinkedHashMap<String, Float>();

    public boolean hasValueForTag(String tag) {
        return this.distributionParameters.containsKey(tag);
    }

    public float getValueForTag(String tag) {
        if (!this.distributionParameters.containsKey(tag)) {
            return 1.0f;
        }
        return this.distributionParameters.get(tag).floatValue();
    }

    public void addDistributionParameter(String tag, float frequency) {
        this.distributionParameters.put(tag, Float.valueOf(frequency));
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeInt(this.distributionParameters.size());
        Set<Map.Entry<String, Float>> entries = this.distributionParameters.entrySet();
        for (Map.Entry<String, Float> entry : entries) {
            oos.writeUTF(entry.getKey());
            oos.writeFloat(entry.getValue().floatValue());
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        if (this.distributionParameters == null) {
            this.distributionParameters = new LinkedHashMap<String, Float>();
        }
        int size = ois.readInt();
        for (int i2 = 0; i2 < size; ++i2) {
            this.distributionParameters.put(ois.readUTF(), Float.valueOf(ois.readFloat()));
        }
    }
}

