/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy;

import com.badlogic.gdx.files.FileHandle;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.DataContext;
import com.neutronio.astrax.app.datapack.DataPack;
import com.neutronio.astrax.app.datapack.EntityID;
import com.neutronio.astrax.app.datapack.game.world.GalaxyMapContext;
import com.neutronio.astrax.app.datapack.game.world.galaxy.Galaxy;
import com.neutronio.astrax.app.datapack.game.world.galaxy.GalaxyRegion;
import com.neutronio.astrax.app.datapack.game.world.galaxy.GalaxyRegionRepository;
import com.neutronio.astrax.app.datapack.game.world.galaxy.GalaxySettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.GalaxyTypeSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.StarSystemSettingsRepository;
import com.neutronio.astrax.app.generator.AbstractFactory;
import com.neutronio.astrax.app.generator.GenericFactory;
import com.neutronio.astrax.ui.ComponentFactory;
import java.util.Map;
import java.util.logging.Level;

public class GalaxyFactory
extends AbstractFactory
implements GenericFactory<Galaxy, GalaxySettings> {
    private static float galaxyRegionCoverage = 0.25f;
    private static int galaxyRegionMinSize = 4;
    private static int galaxyRegionMaxSize = 12;
    private GalaxyMapContext galaxyMapContext;
    private StarSystemSettingsRepository starSystemSettingsRepository;
    private GalaxyRegionRepository galaxyRegionRepository;

    public GalaxyFactory() {
    }

    public GalaxyFactory(DataContext dataContext) {
        super(dataContext);
        this.starSystemSettingsRepository = dataContext.getRepository(StarSystemSettingsRepository.class);
        this.galaxyRegionRepository = dataContext.getRepository(GalaxyRegionRepository.class);
    }

    @Override
    public void setDataPack(DataPack dataPack) {
        super.setDataPack(dataPack);
        this.starSystemSettingsRepository = AstraXApp.astraX.getRepository(StarSystemSettingsRepository.class);
        this.galaxyRegionRepository = AstraXApp.astraX.getRepository(GalaxyRegionRepository.class);
    }

    public void setGalaxyMapContext(GalaxyMapContext galaxyMapContext) {
        this.galaxyMapContext = galaxyMapContext;
    }

    @Override
    public Galaxy create(GalaxySettings galaxySettings) {
        return this.createGalaxy(galaxySettings);
    }

    public Galaxy createGalaxy(GalaxySettings settings) {
        this.logger.log(Level.WARNING, "Creating a new Galaxy with seed: " + this.seed);
        ComponentFactory componentFactory = AstraXApp.astraX.getAppFactoryByClass(ComponentFactory.class);
        EntityID id = this.dataPack.getEntityIDFactory().createID(this.numberGenerator, "galaxy");
        Galaxy galaxy = new Galaxy();
        galaxy.setId(id);
        galaxy.setSeed(this.seed);
        galaxy.setName(settings.galaxyName == null || settings.galaxyName.trim().isEmpty() ? this.generateName() : settings.galaxyName);
        galaxy.setGalaxySettings(settings);
        galaxy.initByTexture(componentFactory.getSkin().getRegion(settings.galaxyTypeSettings.galaxyTexture));
        this.logger.info("Initialize Galaxy Regions...");
        int localX = galaxy.getGalaxySettings().xSectorStartPos + galaxy.getWidth() / 2;
        int localY = galaxy.getGalaxySettings().ySectorStartPos + galaxy.getHeight() / 2;
        this.markRegion(galaxy, galaxy.getRegionSeed(), localX, localY, 6);
        this.seedGalaxyRegions(galaxy, settings);
        return galaxy;
    }

    public void createStarterRegion(Galaxy galaxy) {
        int localX = galaxy.getGalaxySettings().xSectorStartPos + galaxy.getWidth() / 2;
        int localY = galaxy.getGalaxySettings().ySectorStartPos + galaxy.getHeight() / 2;
        this.galaxyMapContext.getGalaxyRegionFactory().createAndCacheRegion(galaxy.getSector((int)localX, (int)localY).regionSeed.intValue(), galaxy.getGalaxySettings().starterRegion, localX, localY);
    }

    public void markRegion(Galaxy galaxy, int regionSeed, int positionX, int positionY, int size) {
        this.logger.finest("Marking region at " + positionX + "/" + positionY + " of size " + size + " with seed " + regionSeed);
        int regionWidth = this.numberGenerator.getRandomInteger(size / 2, 2);
        int regionHeight = this.numberGenerator.getRandomInteger(size / 2, 2);
        for (int x = 0; x < regionWidth; ++x) {
            for (int y = 0; y < regionHeight; ++y) {
                if (!galaxy.isFreeForRegionCollision(x + positionX, y + positionY)) continue;
                galaxy.markForRegionCollision(x + positionX, y + positionY, regionSeed);
            }
        }
    }

    private void seedGalaxyRegions(Galaxy galaxy, GalaxySettings settings) {
        this.numberGenerator.setSeed(galaxy.getRegionSeed());
        this.logger.info("Seeding Regions with global region seed " + galaxy.getRegionSeed());
        int createdRegions = 0;
        float maxRegionCount = settings.getDistributionFor("nebula") * ((float)(galaxy.getWidth() * galaxy.getHeight()) * galaxyRegionCoverage / (float)galaxyRegionMaxSize);
        if (maxRegionCount == 0.0f) {
            throw new AstraXException(AstraXException.ErrorCode.E0003, "Galaxy Regions could not be created from seed");
        }
        this.logger.finest("maxRegionCount: " + maxRegionCount);
        int i2 = 0;
        while ((float)i2 < maxRegionCount) {
            int regionSeedID = this.numberGenerator.getRandom().nextInt();
            int x = this.numberGenerator.getRandomInteger(galaxy.getWidth(), 0);
            int y = this.numberGenerator.getRandomInteger(galaxy.getHeight(), 0);
            int regionSize = this.numberGenerator.getRandomInteger(galaxyRegionMaxSize, galaxyRegionMinSize);
            this.markRegion(galaxy, regionSeedID, x, y, regionSize);
            ++createdRegions;
            ++i2;
        }
        this.logger.info("Regions marked: " + createdRegions);
    }

    public Galaxy loadGalaxy(String galaxyName, FileHandle gameDirectory) {
        this.logger.log(Level.INFO, "Loading Galaxy...");
        ComponentFactory componentFactory = AstraXApp.astraX.getAppFactoryByClass(ComponentFactory.class);
        Galaxy galaxy = (Galaxy)AstraXApp.astraX.getAstraXFiles().readFileBinary(galaxyName + ".dat", gameDirectory);
        this.setSeed(galaxy.getSeed());
        this.logger.log(Level.INFO, "Seed: " + this.seed);
        galaxy.initByTexture(componentFactory.getSkin().getRegion(galaxy.getTextureRegionName()));
        galaxy.getGalaxySettings().galaxyTypeSettings = (GalaxyTypeSettings)AstraXApp.astraX.getRepositoryFactory().findResourceByID(galaxy.getGalaxySettings().galaxyTypeId);
        this.logger.info("Initialize Galaxy Regions...");
        int localX = galaxy.getGalaxySettings().xSectorStartPos + galaxy.getWidth() / 2;
        int localY = galaxy.getGalaxySettings().ySectorStartPos + galaxy.getHeight() / 2;
        this.markRegion(galaxy, galaxy.getRegionSeed(), localX, localY, 6);
        this.seedGalaxyRegions(galaxy, galaxy.getGalaxySettings());
        return galaxy;
    }

    public void createPregeneratedSystems(Galaxy galaxy, GalaxyRegion region, Map<String, Integer> starSystems) {
        this.logger.info("Creating pre-generated StarSystemSettings...");
    }
}

