/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.neutronio.astrax.util.Vector2i;

@Deprecated
public class GalaxyMask {
    private float brightness = 2.5f;
    private TextureRegion imageRegion;
    private Pixmap image;

    public GalaxyMask(TextureRegion region) {
        this.imageRegion = region;
        Texture texture = region.getTexture();
        if (!texture.getTextureData().isPrepared()) {
            texture.getTextureData().prepare();
        }
        this.image = texture.getTextureData().consumePixmap();
    }

    public TextureRegion getImageRegion() {
        return this.imageRegion;
    }

    public float getBrightness() {
        return this.brightness;
    }

    public void setBrightness(float brightness) {
        this.brightness = brightness;
    }

    public int countAverage(int iterations) {
        int count = 0;
        for (int i2 = 0; i2 < iterations; ++i2) {
            int regionWidth = this.imageRegion.getRegionWidth();
            int regionHeight = this.imageRegion.getRegionHeight();
            for (int x = -regionWidth / 2; x < regionWidth / 2; ++x) {
                for (int y = -regionHeight / 2; y < regionHeight / 2; ++y) {
                    Vector2i centered = this.centerCoordinates(x, y);
                    float probability = this.getProbability(centered.x, centered.y);
                    if (!((double)probability > Math.random())) continue;
                    ++count;
                }
            }
        }
        return count / iterations;
    }

    public Vector2i centerCoordinates(int x, int y) {
        return new Vector2i(x + this.imageRegion.getRegionWidth() / 2, y + this.imageRegion.getRegionHeight() / 2);
    }

    public int centerCoordinateX(int x) {
        return x + this.imageRegion.getRegionWidth() / 2;
    }

    public int centerCoordinateY(int y) {
        return y + this.imageRegion.getRegionHeight() / 2;
    }

    public Color getColor(int x, int y) {
        return new Color(this.image.getPixel(this.imageRegion.getRegionX() + x, this.imageRegion.getRegionY() + y));
    }

    public float getProbability(int x, int y) {
        Color color = this.getColor(x, y);
        return MathUtils.clamp((color.r + color.g + color.b) / 3.0f * this.brightness, 0.0f, 1.0f);
    }

    public float getGalaxyDensity(int x, int y) {
        Color color = this.getColor(x, y);
        return MathUtils.clamp((color.r + color.g + color.b) / 3.0f, 0.0f, 1.0f);
    }
}

