/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy;

import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.DataContext;
import com.neutronio.astrax.app.datapack.game.world.GalaxyMapContext;
import com.neutronio.astrax.app.datapack.game.world.galaxy.GalaxyRegion;
import com.neutronio.astrax.app.datapack.game.world.galaxy.GalaxyRegionRepository;
import com.neutronio.astrax.app.datapack.game.world.galaxy.GalaxyRegionSettings;
import com.neutronio.astrax.app.generator.AbstractFactory;
import com.neutronio.astrax.util.collections.ProbabilitySet;
import java.sql.SQLException;

public class GalaxyRegionFactory
extends AbstractFactory {
    private GalaxyRegionRepository repository;
    private GalaxyMapContext galaxyMapContext;

    public GalaxyRegionFactory() {
    }

    public GalaxyRegionFactory(DataContext dataContext) {
        super(dataContext);
        this.repository = this.dataContext.getRepository(GalaxyRegionRepository.class);
    }

    public void setGalaxyMapContext(GalaxyMapContext galaxyMapContext) {
        this.galaxyMapContext = galaxyMapContext;
    }

    public GalaxyRegion createGalaxyRegion(int id, GalaxyRegionSettings regionSettings) {
        if (regionSettings == null) {
            throw new AstraXException(AstraXException.ErrorCode.E0004);
        }
        GalaxyRegion region = new GalaxyRegion();
        region.setId(id);
        region.setGalaxyRegionSettings(regionSettings);
        region.setRegionName(this.generateName());
        return region;
    }

    public GalaxyRegion createGalaxyRegionBySeed(long seed) {
        this.numberGenerator.setSeed(seed);
        GalaxyRegionSettings regionSettings = null;
        ProbabilitySet<String> regionProbabilitySet = this.galaxyMapContext.getGalaxy().getGalaxySettings().galaxyTypeSettings.regionSettings;
        String galaxyRegion = this.setGenerator.generate(this.numberGenerator, regionProbabilitySet);
        if (galaxyRegion == null) {
            throw new AstraXException(AstraXException.ErrorCode.E4001);
        }
        regionSettings = (GalaxyRegionSettings)this.repository.find(galaxyRegion);
        if (regionSettings == null) {
            throw new AstraXException(AstraXException.ErrorCode.E3000, "GalaxyRegionSettings of ID: " + galaxyRegion);
        }
        return this.createGalaxyRegion((int)seed, regionSettings);
    }

    public GalaxyRegion createAndCacheRegion(long seed, String regionSettingsID, int localX, int localY) {
        GalaxyRegion region = this.createGalaxyRegion((int)seed, (GalaxyRegionSettings)this.repository.find(regionSettingsID));
        try {
            this.galaxyMapContext.getGalaxyRegionDAO().insert(region);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.galaxyMapContext.getGalaxy().addRegionToCache(region, localX, localY);
        return region;
    }

    public GalaxyRegion createOrCacheRegion(long seed, int localX, int localY) {
        GalaxyRegion region = null;
        try {
            region = this.galaxyMapContext.getGalaxyRegionDAO().get((int)seed);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (region != null) {
            GalaxyRegionRepository repository = AstraXApp.astraX.getRepository(GalaxyRegionRepository.class);
            region.setGalaxyRegionSettings((GalaxyRegionSettings)repository.find(region.settingsId));
        } else {
            region = this.createGalaxyRegionBySeed(seed);
            try {
                this.galaxyMapContext.getGalaxyRegionDAO().insert(region);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        this.galaxyMapContext.getGalaxy().addRegionToCache(region, localX, localY);
        return region;
    }
}

