/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy;

import com.neutronio.astrax.app.datapack.GameSessionFactory;
import com.neutronio.astrax.app.datapack.game.DiscoveryTarget;
import com.neutronio.astrax.app.datapack.game.world.CelestialTarget;
import com.neutronio.astrax.app.datapack.game.world.GalaxyMapContext;
import com.neutronio.astrax.app.datapack.game.world.SatelliteTarget;
import com.neutronio.astrax.app.datapack.game.world.Targetable;
import com.neutronio.astrax.app.datapack.game.world.galaxy.Sector;
import com.neutronio.astrax.app.datapack.game.world.galaxy.SectorTracker;
import com.neutronio.astrax.app.datapack.game.world.galaxy.StarSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.DiscoverySystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.NavigationBookmark;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.Planet;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.StarSystemHeader;
import com.neutronio.astrax.app.screen.SpaceScreen;
import com.neutronio.astrax.util.AstraXUtil;
import com.neutronio.astrax.util.collections.GroupedMap;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;

public class SectorStream
implements SectorTracker.SectorTrackerListener {
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private Sector<StarSystem> currentSector;
    private SpaceScreen spaceScreen;
    private GalaxyMapContext galaxyMapContext;
    private GameSessionFactory gameSessionFactory;

    public void setGameSessionFactory(GameSessionFactory gameSessionFactory) {
        this.gameSessionFactory = gameSessionFactory;
    }

    public Sector<StarSystem> getCurrentSector() {
        return this.currentSector;
    }

    public void setSpaceScreen(SpaceScreen spaceScreen) {
        this.spaceScreen = spaceScreen;
    }

    public void setGalaxyMapContext(GalaxyMapContext galaxyMapContext) {
        this.galaxyMapContext = galaxyMapContext;
    }

    public void addNavigationBookmarkToDatabase(NavigationBookmark bookmark) throws SQLException {
        this.galaxyMapContext.getNavigationBookmarkDAO().insert(this.currentSector.tileID, bookmark);
    }

    @Override
    public void onSectorEnter(int x, int y, float globalX, float globalY) {
        this.logger.info("Entering Sector " + x + " " + y);
        try {
            this.gameSessionFactory.savePlayer(this.spaceScreen.getAstraxGame().getLocalPlayer(), this.spaceScreen.getAstraxGame().getGameDirectory());
            StarSystemHeader starSystem = this.galaxyMapContext.getStarSystemHeaderDAO().getByLocation(x + this.galaxyMapContext.getGalaxy().getWidth() / 2, y + this.galaxyMapContext.getGalaxy().getHeight() / 2);
            DiscoveryInfo discoveryInfo = new DiscoveryInfo();
            if (starSystem == null) {
                this.createNewSector(discoveryInfo, x, y);
            } else {
                this.regenerateSector(discoveryInfo, starSystem, x, y);
            }
            this.logger.finest("Initialize Player Spacecraft > Discovery System with new Targets");
            DiscoverySystem discoverySystem = ((Satellite)this.spaceScreen.getAstraxGame().getLocalPlayer().getPlayerTarget().getModel()).getSystem(DiscoverySystem.class);
            discoverySystem.initialize(discoveryInfo);
            discoverySystem.synchronizeBookmarks();
            this.logger.finest("Place created star system to the appropriate position");
            this.currentSector.getChunk().getGraphics().setPosition(globalX, globalY);
            this.currentSector.getChunk().getBackgroundGraphics().setPosition(globalX, globalY);
            this.logger.finest("Load merchants for NPC spacecraft");
            List<SatelliteTarget> satelliteTargets = AstraXUtil.filterTargets(this.currentSector.getChunk().getSystemMembers(), SatelliteTarget.class);
            this.gameSessionFactory.loadMerchants(satelliteTargets);
            this.logger.info("Updating SpaceScreen & UI");
            this.spaceScreen.switchStarSystemTo(this.currentSector);
            this.spaceScreen.updateStarMap();
            this.spaceScreen.getTabMenu().setSectorCoordinates(x, y);
            this.spaceScreen.getMapTab().update(this.currentSector);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onSectorLeave(int x, int y) {
        this.logger.info("Leaving Sector " + x + " " + y);
        this.logger.info("Saving Sector of id " + this.currentSector.getTileID());
        this.gameSessionFactory.saveGameInfo(this.spaceScreen.getAstraxGame(), this.spaceScreen.getAstraxGame().getLocalPlayer());
        this.gameSessionFactory.saveNPCSatellites(this.currentSector.getChunk().getSystemMembers());
        try {
            StarSystemHeader starSystemHeader = new StarSystemHeader(this.currentSector);
            DiscoverySystem discoverySystem = ((Satellite)this.spaceScreen.getAstraxGame().getLocalPlayer().getPlayerTarget().getModel()).getSystem(DiscoverySystem.class);
            starSystemHeader.discovered = discoverySystem.getDiscoveredFactor();
            starSystemHeader.knownMemberCount = discoverySystem.getDatabank().getDiscoveries().size();
            this.galaxyMapContext.getStarSystemHeaderDAO().update(starSystemHeader);
            this.gameSessionFactory.updateAsteroids(this.currentSector);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void createNewSector(DiscoveryInfo discoveryInfo, int x, int y) throws SQLException {
        this.logger.finest("Generate a new sector...");
        this.currentSector = this.galaxyMapContext.getStarSystemSectorFactory().generateSector(x, y);
        this.gameSessionFactory.saveAsteroids(this.currentSector);
        this.gameSessionFactory.saveNPCSatellites(this.currentSector.getChunk().getSystemMembers());
        discoveryInfo.systemMembers = this.currentSector.getChunk().getSystemMembers();
        StarSystemHeader starSystemHeader = new StarSystemHeader(this.currentSector);
        this.galaxyMapContext.getStarSystemHeaderDAO().insert(starSystemHeader);
        if (this.currentSector.getRegion() != null) {
            this.galaxyMapContext.getStarSystemHeaderDAO().updateSystemWithRegionID(this.currentSector.tileID, this.currentSector.getRegion().id);
        }
        discoveryInfo.discoveryTargets = this.gameSessionFactory.createEmptyDiscoveryTargetList(discoveryInfo.systemMembers);
    }

    private void regenerateSector(DiscoveryInfo discoveryInfo, StarSystemHeader starSystem, int x, int y) throws SQLException {
        this.logger.finest("Regenerate the sector...");
        this.currentSector = this.galaxyMapContext.getStarSystemSectorFactory().generateSector(x, y);
        discoveryInfo.systemMembers = this.currentSector.getChunk().getSystemMembers();
        this.currentSector.getChunk().setSystemTime(starSystem.systemTime);
        this.currentSector.setTileID(starSystem.id);
        this.gameSessionFactory.synchronizeAsteroidsWithDatabase(this.currentSector);
        discoveryInfo.discoveryTargets = this.gameSessionFactory.loadAndCreateDiscoveryTargets(starSystem, discoveryInfo.systemMembers);
        for (DiscoveryTarget discoveryTarget : discoveryInfo.discoveryTargets) {
            if (discoveryTarget.discovery == null) continue;
            List<String> discoveries = this.galaxyMapContext.getDiscoveryDAO().getChildDiscoveriesFor(discoveryTarget.discovery.id);
            discoveryInfo.childDiscoveries.addAllToGroup(discoveryTarget.discovery.entityId, discoveries);
            if (!(discoveryTarget.target instanceof CelestialTarget)) continue;
            int allTraits = ((Planet)((CelestialTarget)discoveryTarget.target).getModel()).getCustomPlanetSettings().traits.size();
            discoveryTarget.discovery.discoveredFactor = discoveries != null ? (float)discoveries.size() / (float)allTraits : 0.0f;
        }
        if (this.currentSector.getRegion() != null) {
            this.galaxyMapContext.getStarSystemHeaderDAO().updateSystemWithRegionID(this.currentSector.tileID, this.currentSector.getRegion().id);
        }
    }

    public class DiscoveryInfo {
        public Collection<Targetable> systemMembers = null;
        public List<DiscoveryTarget> discoveryTargets = null;
        public GroupedMap<Object, String> childDiscoveries = new GroupedMap();
    }
}

