/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy;

import java.util.ArrayList;
import java.util.List;

public class SectorTracker {
    private int sectorBoundsX = 100;
    private int sectorBoundsY = 100;
    private int xOld = 0;
    private int yOld = 0;
    private int xNew = 0;
    private int yNew = 0;
    private float xGlobal = 0.0f;
    private float yGlobal = 0.0f;
    private List<SectorTrackerListener> listeners = new ArrayList<SectorTrackerListener>();
    private boolean firstInvoked = true;

    public void setSectorBoundsX(int sectorBoundsX) {
        this.sectorBoundsX = sectorBoundsX;
    }

    public void setSectorBoundsY(int sectorBoundsY) {
        this.sectorBoundsY = sectorBoundsY;
    }

    public void addListener(SectorTrackerListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
    }

    private void fireOnSectorEnter(int x, int y, float globalX, float globalY) {
        for (SectorTrackerListener listener : this.listeners) {
            listener.onSectorEnter(x, y, globalX, globalY);
        }
    }

    private void fireOnSectorLeave(int x, int y) {
        for (SectorTrackerListener listener : this.listeners) {
            listener.onSectorLeave(x, y);
        }
    }

    public int getSectorBoundsX() {
        return this.sectorBoundsX;
    }

    public int getSectorBoundsY() {
        return this.sectorBoundsY;
    }

    public int getSectorXCoordinate(float playerXCoords) {
        return (int)Math.floor((playerXCoords + (float)this.sectorBoundsX / 2.0f) / (float)this.sectorBoundsX);
    }

    public int getSectorYCoordinate(float playerYCoords) {
        return (int)Math.floor((playerYCoords + (float)this.sectorBoundsY / 2.0f) / (float)this.sectorBoundsY);
    }

    public void checkSector(float playerXCoords, float playerYCoords) {
        this.xNew = this.getSectorXCoordinate(playerXCoords);
        this.yNew = this.getSectorYCoordinate(playerYCoords);
        if (this.firstInvoked) {
            this.xGlobal = (float)this.xNew * (float)this.sectorBoundsX;
            this.yGlobal = (float)this.yNew * (float)this.sectorBoundsY;
            this.fireOnSectorEnter(this.xNew, this.yNew, this.xGlobal, this.yGlobal);
            this.firstInvoked = false;
        }
        if (this.xNew != this.xOld || this.yNew != this.yOld) {
            this.xGlobal = (float)this.xNew * (float)this.sectorBoundsX;
            this.yGlobal = (float)this.yNew * (float)this.sectorBoundsY;
            this.fireOnSectorLeave(this.xOld, this.yOld);
            this.fireOnSectorEnter(this.xNew, this.yNew, this.xGlobal, this.yGlobal);
        }
        this.xOld = this.xNew;
        this.yOld = this.yNew;
    }

    public static interface SectorTrackerListener {
        public void onSectorEnter(int var1, int var2, float var3, float var4);

        public void onSectorLeave(int var1, int var2);
    }
}

