/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.neutronio.astrax.app.datapack.EntityID;
import com.neutronio.astrax.app.datapack.game.world.Targetable;
import com.neutronio.astrax.app.datapack.game.world.galaxy.GalaxyRegion;
import com.neutronio.astrax.app.datapack.game.world.galaxy.StarSystemListener;
import com.neutronio.astrax.app.datapack.game.world.galaxy.StarSystemSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.OrbitalBelt;
import com.neutronio.astrax.gfx.StarSystemGraphics;
import com.neutronio.astrax.gfx.bg.StarSystemBackgroundGraphics;
import com.neutronio.astrax.gfx.bg.StarSystemBackgroundSettings;
import com.neutronio.astrax.util.Tree;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class StarSystem
implements Serializable {
    private GalaxyRegion region;
    private Targetable sun;
    private float systemTime;
    private List<OrbitalBelt> belts = new ArrayList<OrbitalBelt>();
    private Tree<Targetable> systemStructure = new Tree();
    private Map<EntityID, Targetable> systemTargets = new LinkedHashMap<EntityID, Targetable>();
    private transient StarSystemSettings settings;
    private transient StarSystemBackgroundSettings backgroundGraphicsSettings;
    private transient StarSystemGraphics graphics;
    private transient StarSystemBackgroundGraphics backgroundGraphics;
    private List<StarSystemListener> listeners = new ArrayList<StarSystemListener>();

    public StarSystem(Targetable sun) {
        this.sun = sun;
        if (sun != null) {
            this.registerTarget(sun);
        }
    }

    public void setSystemTime(float systemTime) {
        this.systemTime = systemTime;
    }

    public float getSystemTime() {
        return this.systemTime;
    }

    public GalaxyRegion getRegion() {
        return this.region;
    }

    public void setRegion(GalaxyRegion region) {
        this.region = region;
    }

    public List<Targetable> getChildrenOf(EntityID id) {
        return null;
    }

    public void getLocalCoordinatesOfMember(EntityID id, Vector2 store) {
        Targetable target = this.systemTargets.get(id);
        Object current = target.getGraphics();
        do {
            store.x += ((Actor)current).getX();
            store.y += ((Actor)current).getY();
        } while (!Objects.equals(current = ((Actor)current).getParent(), this.graphics) && current != null);
    }

    public String getName() {
        return this.sun.getName();
    }

    public Tree<Targetable> getSystemStructure() {
        return this.systemStructure;
    }

    public void setSystemStructure(Tree<Targetable> systemStructure) {
        this.systemStructure = systemStructure;
    }

    public void addListener(StarSystemListener listener) {
        if (listener == null) {
            return;
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(StarSystemListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public StarSystemSettings getSettings() {
        return this.settings;
    }

    public void setSettings(StarSystemSettings settings) {
        this.settings = settings;
    }

    public Targetable getSun() {
        return this.sun;
    }

    public StarSystemBackgroundGraphics getBackgroundGraphics() {
        return this.backgroundGraphics;
    }

    public void setBackgroundGraphics(StarSystemBackgroundGraphics backgroundGraphics) {
        this.backgroundGraphics = backgroundGraphics;
    }

    public StarSystemGraphics getGraphics() {
        return this.graphics;
    }

    public StarSystemBackgroundSettings getBackgroundGraphicsSettings() {
        return this.backgroundGraphicsSettings;
    }

    public void setBackgroundGraphicsSettings(StarSystemBackgroundSettings backgroundGraphicsSettings) {
        this.backgroundGraphicsSettings = backgroundGraphicsSettings;
    }

    public void setGraphics(StarSystemGraphics graphics) {
        this.graphics = graphics;
    }

    public void addBelt(OrbitalBelt belt) {
        this.belts.add(belt);
    }

    public void registerTarget(Targetable target) {
        this.systemTargets.put(target.getID(), target);
        for (StarSystemListener listener : this.listeners) {
            listener.onAddToTotalTargets(target);
        }
    }

    public Targetable findMember(EntityID id) {
        return this.systemTargets.get(id);
    }

    public List<Targetable> getSystemMembersCopy() {
        ArrayList<Targetable> result = new ArrayList<Targetable>();
        for (Targetable member : this.systemTargets.values()) {
            result.add(member);
        }
        return result;
    }

    public Collection<Targetable> getSystemMembers() {
        return this.systemTargets.values();
    }

    public int getPlanetCount() {
        return this.systemTargets.size();
    }

    public void update(float delta) {
        this.systemTime += delta;
        for (Targetable systemMember : this.systemTargets.values()) {
            systemMember.update(delta, this.systemTime);
        }
    }
}

