/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy;

import com.badlogic.gdx.math.MathUtils;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.DataContext;
import com.neutronio.astrax.app.datapack.DataPack;
import com.neutronio.astrax.app.datapack.game.world.GalaxyMapContext;
import com.neutronio.astrax.app.datapack.game.world.galaxy.Galaxy;
import com.neutronio.astrax.app.datapack.game.world.galaxy.GalaxyRegion;
import com.neutronio.astrax.app.datapack.game.world.galaxy.GalaxyRegionFactory;
import com.neutronio.astrax.app.datapack.game.world.galaxy.Sector;
import com.neutronio.astrax.app.datapack.game.world.galaxy.SectorGenerator;
import com.neutronio.astrax.app.datapack.game.world.galaxy.StarSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.StarSystemSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.StarSystemSettingsRepository;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.StarSystemFactory;
import com.neutronio.astrax.app.generator.AbstractFactory;
import com.neutronio.astrax.gfx.bg.StarSystemBackgroundSettings;
import com.neutronio.astrax.util.Counter;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StarSystemSectorFactory
extends AbstractFactory
implements SectorGenerator<StarSystem> {
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private Counter<String> starSystemCounter = new Counter();
    private GalaxyMapContext galaxyMapContext;
    private GalaxyRegionFactory galaxyRegionFactory;

    public StarSystemSectorFactory() {
    }

    public StarSystemSectorFactory(DataContext dataContext) {
        super(dataContext);
    }

    public void setGalaxyMapContext(GalaxyMapContext galaxyMapContext) {
        this.galaxyMapContext = galaxyMapContext;
    }

    public DataPack getDataPack() {
        return this.dataPack;
    }

    public void prepareBackground(StarSystemBackgroundSettings settings, int worldX, int worldY) {
        settings.galaxyDensity = this.galaxyMapContext.getGalaxy().getDensity(worldX, worldY);
        this.logger.fine("Galaxy visual density at sector: " + settings.galaxyDensity);
        for (StarSystemBackgroundSettings.BackgroundScatterSetting backgroundScatterSetting : settings.scatterSettings) {
            backgroundScatterSetting.density = MathUtils.clamp(settings.galaxyDensity * backgroundScatterSetting.baseDensity, 0.0f, 1.0f);
        }
    }

    @Override
    public Sector<StarSystem> generateSector(int worldX, int worldY) {
        this.logger.log(Level.INFO, "Generating Sector @ " + worldX + " | " + worldY);
        StarSystem system = null;
        GalaxyRegion region = null;
        int localX = worldX + this.galaxyMapContext.getGalaxy().getWidth() / 2;
        int localY = worldY + this.galaxyMapContext.getGalaxy().getHeight() / 2;
        Galaxy.SectorProperty galaxySector = this.galaxyMapContext.getGalaxy().getSector(localX, localY);
        this.logger.log(Level.INFO, "... Sector Seed " + galaxySector.seed);
        this.galaxyMapContext.getStarSystemFactory().setSeed(galaxySector.seed);
        this.numberGenerator.setSeed(galaxySector.seed);
        boolean homeSystem = this.isHomeSystem(worldX, worldY);
        if (galaxySector.regionSeed != null) {
            this.logger.log(Level.INFO, "Region available.");
            this.galaxyMapContext.getGalaxyRegionFactory().setSeed(galaxySector.regionSeed.intValue());
            region = this.galaxyMapContext.getGalaxyRegionFactory().createOrCacheRegion(galaxySector.regionSeed.intValue(), localX, localY);
        }
        if (homeSystem) {
            this.logger.log(Level.FINE, "Creating Home System");
            system = this.createHomeSystem(region, worldX, worldY);
        } else {
            this.logger.log(Level.FINE, "Creating Random System");
            float probability = this.galaxyMapContext.getGalaxy().getDensity(worldX, worldY) * 100.0f * this.galaxyMapContext.getGalaxy().getGalaxySettings().getDistributionFor("starsystem");
            boolean generateSystem = this.numberGenerator.isTrue(probability);
            this.logger.log(Level.FINE, "Generate System: " + generateSystem + " Probability: " + probability);
            if (generateSystem) {
                system = this.createRandomSystem(region, worldX, worldY);
            } else {
                StarSystemSettings emptySystemSettings = (StarSystemSettings)AstraXApp.astraX.findResource("solarsystem_asteroids");
                system = this.galaxyMapContext.getStarSystemFactory().generateStarSystem(emptySystemSettings, this.galaxyMapContext.getGalaxy().getGalaxySettings().galaxyTypeSettings.defaultBackgroundSettings);
            }
        }
        this.starSystemCounter.addOne(system.getSettings().getId());
        this.logger.log(Level.INFO, "Sector created: " + system.getSettings().getName());
        this.logger.log(Level.INFO, "Systems generated so far: " + this.starSystemCounter);
        Sector<StarSystem> sector = new Sector<StarSystem>();
        sector.setCoordinates(worldX, worldY);
        sector.setChunk(system);
        sector.setRegion(region);
        sector.setTileID(galaxySector.seed);
        return sector;
    }

    public StarSystem createStarSystem(GalaxyRegion region, StarSystemSettings starterSystemSettings, int worldX, int worldY) {
        this.logger.fine("Region: " + region);
        AstraXApp.astraX.getFactoryByClass(StarSystemFactory.class).setRegionDistributionSettings(region != null ? region.galaxyRegionSettings.galaxyDistributionSettings : null);
        StarSystemBackgroundSettings defaultBackgroundSettings = this.galaxyMapContext.getGalaxy().getGalaxySettings().galaxyTypeSettings.defaultBackgroundSettings;
        this.prepareBackground(defaultBackgroundSettings, worldX, worldY);
        StarSystemBackgroundSettings systemBackgroundSettings = region == null ? defaultBackgroundSettings : region.backgroundSettings;
        StarSystem starSystem = AstraXApp.astraX.getFactoryByClass(StarSystemFactory.class).generateStarSystem(starterSystemSettings, systemBackgroundSettings);
        starSystem.setRegion(region);
        return starSystem;
    }

    private boolean isHomeSystem(int worldX, int worldY) {
        return this.galaxyMapContext.getGalaxy().getGalaxySettings().xSectorStartPos == worldX && this.galaxyMapContext.getGalaxy().getGalaxySettings().ySectorStartPos == worldY;
    }

    private StarSystem createHomeSystem(GalaxyRegion region, int worldX, int worldY) {
        StarSystemSettings starterSystemSettings = (StarSystemSettings)AstraXApp.astraX.findResource(this.galaxyMapContext.getGalaxy().getGalaxySettings().starterSystem);
        return this.createStarSystem(region, starterSystemSettings, worldX, worldY);
    }

    private StarSystem createRandomSystem(GalaxyRegion region, int worldX, int worldY) {
        StarSystemSettingsRepository repository = AstraXApp.astraX.getRepository(StarSystemSettingsRepository.class);
        List<StarSystemSettings> allSystems = repository.getAvailableStarSystems();
        StarSystemSettings randomSystemSettings = this.numberGenerator.getRandomEntry(allSystems);
        return this.createStarSystem(region, randomSystemSettings, worldX, worldY);
    }
}

