/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.asteroid;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.MathUtils;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.DataContext;
import com.neutronio.astrax.app.datapack.EntityID;
import com.neutronio.astrax.app.datapack.game.mechanics.resources.Resource;
import com.neutronio.astrax.app.datapack.game.mechanics.resources.ResourceDeposit;
import com.neutronio.astrax.app.datapack.game.mechanics.resources.ResourceDepositSettings;
import com.neutronio.astrax.app.datapack.game.world.AsteroidTarget;
import com.neutronio.astrax.app.datapack.game.world.galaxy.asteroid.Asteroid;
import com.neutronio.astrax.app.datapack.game.world.galaxy.asteroid.AsteroidGeneratorSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.asteroid.AsteroidGeneratorSettingsRepository;
import com.neutronio.astrax.app.datapack.game.world.galaxy.asteroid.AsteroidSettings;
import com.neutronio.astrax.app.generator.AbstractFactory;
import com.neutronio.astrax.app.generator.Generator;
import com.neutronio.astrax.app.generator.GenericFactory;
import com.neutronio.astrax.app.generator.NameSpace;
import com.neutronio.astrax.app.generator.TargetFactory;
import com.neutronio.astrax.app.repository.ResourceRepository;
import com.neutronio.astrax.gfx.AsteroidGraphics;
import com.neutronio.astrax.gfx.AsteroidGraphicsFactory;
import com.neutronio.astrax.io.binary.Serializer;
import com.neutronio.astrax.io.binary.game.world.galaxy.SavedAsteroidTarget;
import com.neutronio.astrax.util.ColorBlend;
import com.neutronio.astrax.util.collections.ProbabilitySet;

public class AsteroidFactory
extends AbstractFactory
implements Generator<AsteroidSettings, AsteroidGeneratorSettings>,
GenericFactory<Asteroid, AsteroidSettings>,
TargetFactory<AsteroidTarget, AsteroidGeneratorSettings>,
Serializer<AsteroidTarget, SavedAsteroidTarget> {
    private float defaultAsteroidSize = 500.0f;
    private AsteroidGraphicsFactory asteroidGraphicsFactory;

    public AsteroidFactory() {
        this.asteroidGraphicsFactory = AstraXApp.astraX.getFactoryByClass(AsteroidGraphicsFactory.class);
    }

    public AsteroidFactory(DataContext dataContext) {
        super(dataContext);
        this.asteroidGraphicsFactory = dataContext.getFactory(AsteroidGraphicsFactory.class);
    }

    @Override
    public Asteroid create(AsteroidSettings asteroidSettings) {
        Asteroid asteroid = new Asteroid();
        asteroid.name = asteroidSettings.name;
        asteroid.setSettings(asteroidSettings);
        asteroid.setResources(asteroidSettings.resourceSettings);
        return asteroid;
    }

    @Override
    public AsteroidSettings generate(AsteroidGeneratorSettings asteroidGeneratorSettings) {
        AsteroidSettings asteroidSettings = new AsteroidSettings();
        asteroidSettings.name = this.generateName();
        asteroidSettings.resourceSettings = this.createResourceDeposit(asteroidGeneratorSettings.resourceDepositSettings);
        ResourceRepository resourceRepository = AstraXApp.astraX.getRepository(ResourceRepository.class);
        ProbabilitySet<String> resourceSet = asteroidGeneratorSettings.resourceDepositSettings.resources;
        Color combinedColor = Color.valueOf("808080");
        this.logger.fine("Mixing colors for asteroid...");
        for (int i2 = 0; i2 < resourceSet.size(); ++i2) {
            String resourceID = resourceSet.getItemAt(i2);
            Resource resource = (Resource)resourceRepository.find(resourceID);
            if (resource == null) continue;
            float alpha = MathUtils.clamp(1.0f - resourceSet.getProbabilityAt(i2) / 100.0f, 0.0f, 1.0f);
            this.logger.fine("Resource color: " + resource.color + " " + alpha);
            combinedColor = ColorBlend.INTERPOLATE.mix(combinedColor, resource.color, alpha);
        }
        combinedColor.a = 1.0f;
        this.logger.fine("Combined color: " + combinedColor);
        asteroidSettings.baseImage = this.numberGenerator.getRandomEntry(asteroidGeneratorSettings.bodyImages);
        if (!asteroidGeneratorSettings.resourceImages.isEmpty()) {
            asteroidSettings.resourceImage = this.numberGenerator.getRandomEntry(asteroidGeneratorSettings.resourceImages);
        }
        asteroidSettings.particleEmitter = this.numberGenerator.getRandomEntry(asteroidGeneratorSettings.particleEmitters);
        asteroidSettings.bodyColor = this.numberGenerator.getRandomEntry(asteroidGeneratorSettings.bodyColors);
        asteroidSettings.resourceColor = combinedColor;
        return asteroidSettings;
    }

    @Override
    public AsteroidTarget createTarget(AsteroidGeneratorSettings asteroidSettings) {
        this.logger.fine("Creating target with current seed " + this.numberGenerator.getSeed());
        AsteroidGraphicsFactory asteroidGraphicsFactory = AstraXApp.astraX.getFactoryByClass(AsteroidGraphicsFactory.class);
        AsteroidSettings settings = this.generate(asteroidSettings);
        Asteroid asteroid = this.create(settings);
        AsteroidGraphics asteroidGraphics = asteroidGraphicsFactory.create(settings);
        return new AsteroidTarget(this.entityIDFactory.createID(this.numberGenerator), asteroid, asteroidGraphics);
    }

    @Override
    public AsteroidTarget createShuffledTarget(NameSpace nameSpace) {
        AsteroidGeneratorSettingsRepository repository = AstraXApp.astraX.getRepository(AsteroidGeneratorSettingsRepository.class);
        AsteroidGeneratorSettings asteroidGeneratorSettings = null;
        asteroidGeneratorSettings = nameSpace.getArchetype() != null ? (AsteroidGeneratorSettings)repository.find(nameSpace.getArchetype()) : (AsteroidGeneratorSettings)this.numberGenerator.getRandomEntry(repository.all());
        AsteroidTarget asteroid = this.createTarget(asteroidGeneratorSettings);
        asteroid.setNameSpace(nameSpace);
        return asteroid;
    }

    public ResourceDeposit createResourceDeposit(ResourceDepositSettings resourceDepositSettings) {
        ResourceDeposit resourceDeposit = new ResourceDeposit();
        resourceDeposit.setName(resourceDepositSettings.depositName);
        resourceDeposit.setResourceSettings(resourceDepositSettings);
        int maxDepositSize = this.numberGenerator.getRandomInteger(resourceDepositSettings.getMaxDepositSize(), resourceDepositSettings.getMinDepositSize());
        resourceDeposit.setDepositSize(maxDepositSize);
        resourceDeposit.setMaxDepositSize(maxDepositSize);
        resourceDeposit.setMiningDifficulty(this.numberGenerator.getRandomFloat(resourceDepositSettings.getMaxMiningDifficulty(), resourceDepositSettings.getMinMiningDifficulty()));
        return resourceDeposit;
    }

    @Override
    public SavedAsteroidTarget serialize(AsteroidTarget toSave) {
        return null;
    }

    @Override
    public AsteroidTarget deserialize(SavedAsteroidTarget savable) {
        AsteroidSettings asteroidSettings = new AsteroidSettings(savable.settings);
        Asteroid asteroid = this.create(asteroidSettings);
        EntityID entityID = null;
        entityID = savable.entityID != null ? new EntityID(savable.entityID) : this.entityIDFactory.createID(this.numberGenerator);
        AsteroidGraphics asteroidGraphics = this.asteroidGraphicsFactory.create(asteroidSettings);
        return new AsteroidTarget(entityID, asteroid, asteroidGraphics);
    }
}

