/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.planet;

public class Topography {
    protected Integer maxDepth = Integer.MAX_VALUE;
    protected Integer maxHeight = Integer.MIN_VALUE;
    protected Float erosionRate = Float.valueOf(0.0f);
    protected Boolean available = true;

    public Topography() {
    }

    public Topography(int maxDepth, int maxHeight, float erosionRate) {
        this.maxDepth = maxDepth;
        this.maxHeight = maxHeight;
        this.erosionRate = Float.valueOf(erosionRate);
    }

    public Topography combine(Topography topography) {
        if (!this.available.booleanValue()) {
            return this;
        }
        if (topography.maxDepth != null) {
            this.maxDepth = Math.min(topography.maxDepth, this.maxDepth);
        }
        if (topography.maxHeight != null) {
            this.maxHeight = Math.max(topography.maxHeight, this.maxHeight);
        }
        if (topography.erosionRate != null) {
            this.erosionRate = Float.valueOf(this.erosionRate.floatValue() + topography.erosionRate.floatValue());
        }
        if (topography.available != null) {
            this.available = this.available != false && topography.available != false;
        }
        if (!this.available.booleanValue()) {
            this.maxDepth = 0;
            this.maxHeight = 0;
            this.erosionRate = Float.valueOf(0.0f);
        }
        return this;
    }

    public Boolean getAvailable() {
        return this.available;
    }

    public void setAvailable(Boolean available) {
        this.available = available;
    }

    public Integer getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(Integer maxDepth) {
        this.maxDepth = maxDepth;
    }

    public Integer getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(Integer maxHeight) {
        this.maxHeight = maxHeight;
    }

    public Float getErosionRate() {
        return this.erosionRate;
    }

    public void setErosionRate(Float erosionRate) {
        this.erosionRate = erosionRate;
    }

    public String toString() {
        return "Topography{maxDepth=" + this.maxDepth + " km, maxHeight=" + this.maxHeight + " km, erosionRate=" + this.erosionRate + ", available=" + this.available + '}';
    }
}

