/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.satellite;

import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.datapack.game.DiscoveryTarget;
import com.neutronio.astrax.app.datapack.game.world.Targetable;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteGrid;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.FunctionalSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.Module;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.Cargobay;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.docking.DockingState;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.docking.DockingSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.mining.MiningDrill;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.propulsion.Thruster;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors.TargetSorter;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.tanks.TankSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.DiscoverySystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.ManmadeObject;
import com.neutronio.astrax.io.AstraXFiles;
import com.neutronio.astrax.util.Vector2i;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Satellite
implements ManmadeObject {
    private SimulationMode simulationMode = SimulationMode.NONE;
    private String name = "";
    private float currentHp = 0.0f;
    public AstraXFiles.AstraXFile satelliteGridFile;
    protected SatelliteGrid satelliteGrid;
    protected Map<Class, FunctionalSystem> systems = new LinkedHashMap<Class, FunctionalSystem>();
    protected Map<Vector2i, Thruster> thrusters = new LinkedHashMap<Vector2i, Thruster>();
    protected Map<Vector2i, MiningDrill> miningDrills = new LinkedHashMap<Vector2i, MiningDrill>();
    protected List<Module> modules = new ArrayList<Module>();
    protected TankSystem tankSystemTemp;

    public void setSatelliteGridFile(AstraXFiles.AstraXFile satelliteGridFile) {
        this.satelliteGridFile = satelliteGridFile;
    }

    public AstraXFiles.AstraXFile getSatelliteGridFile() {
        return this.satelliteGridFile;
    }

    public SatelliteGrid getSatelliteGrid() {
        return this.satelliteGrid;
    }

    public void setSatelliteGrid(SatelliteGrid satelliteGrid) {
        this.satelliteGrid = satelliteGrid;
    }

    public void addModule(Module module) {
        this.modules.add(module);
    }

    public List<Module> getModules() {
        return Collections.unmodifiableList(this.modules);
    }

    public void registerThruster(Thruster thruster) {
        this.thrusters.put(thruster.getLocation(), thruster);
    }

    public void registerMiningDrill(MiningDrill miningDrill) {
        this.miningDrills.put(miningDrill.getLocation(), miningDrill);
    }

    public Thruster getThruster(Vector2i location) {
        return this.thrusters.get(location);
    }

    public MiningDrill getMiningDrill(Vector2i location) {
        return this.miningDrills.get(location);
    }

    public void addSystem(FunctionalSystem system) {
        if (this.hasSystem(system.getClass())) {
            throw new AstraXException(AstraXException.ErrorCode.E0004, "System " + system.getClass().getCanonicalName() + " already set");
        }
        if (system != null) {
            this.systems.put(system.getClass(), system);
        }
    }

    public SimulationMode getSimulationMode() {
        return this.simulationMode;
    }

    public void setSimulationMode(SimulationMode simulationMode) {
        this.simulationMode = simulationMode;
    }

    public <T extends FunctionalSystem> boolean hasSystem(Class<T> clazz) {
        return this.systems.containsKey(clazz);
    }

    public <T extends FunctionalSystem> T getSystem(Class<T> clazz) {
        return (T)this.systems.get(clazz);
    }

    public boolean isDocked() {
        if (this.hasSystem(DockingSystem.class)) {
            return this.getSystem(DockingSystem.class).getDockingState().equals((Object)DockingState.DOCKED);
        }
        return false;
    }

    public void updateSystems(float delta) {
        switch (this.simulationMode) {
            case PLAYER: {
                for (Module module : this.modules) {
                    module.update(delta);
                }
                for (FunctionalSystem system : this.systems.values()) {
                    system.update(delta);
                }
                break;
            }
            case NPC: {
                for (Module module : this.modules) {
                    module.update(delta);
                }
                for (FunctionalSystem system : this.systems.values()) {
                    if (system instanceof DiscoverySystem) continue;
                    system.update(delta);
                }
            }
            case NONE: {
                break;
            }
        }
    }

    public List<TargetSorter.Target> getTargetsInRange() {
        return this.getSystem(DiscoverySystem.class).getProximitySensor().getTargets_WithinDistance(false);
    }

    public boolean scanTarget(DiscoveryTarget target) {
        DiscoverySystem discoverySystem;
        if (this.hasSystem(DiscoverySystem.class) && (discoverySystem = this.getSystem(DiscoverySystem.class)).getProximitySensor().isInScannerRange((Targetable)target.target)) {
            discoverySystem.getScanner().scanTarget(discoverySystem.getProximitySensor(), target);
            return true;
        }
        return false;
    }

    public boolean unsetTarget() {
        if (this.hasSystem(DiscoverySystem.class)) {
            DiscoverySystem discoverySystem = this.getSystem(DiscoverySystem.class);
            discoverySystem.getTargetComputer().setCurrentTarget(null, Satellite.class);
            return true;
        }
        return false;
    }

    public boolean isInSensorRange(Targetable target) {
        if (this.hasSystem(DiscoverySystem.class)) {
            DiscoverySystem discoverySystem = this.getSystem(DiscoverySystem.class);
            return discoverySystem.getProximitySensor().isInScannerRange(target);
        }
        return false;
    }

    public boolean isTargetSelected(Targetable target) {
        if (this.hasSystem(DiscoverySystem.class)) {
            DiscoverySystem discoverySystem = this.getSystem(DiscoverySystem.class);
            return discoverySystem.getTargetComputer().isTargetSelected(target.getID());
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public float getHpMax() {
        return this.satelliteGrid.hullpoints;
    }

    public float getHpCurrent() {
        return this.currentHp;
    }

    public void setHpCurrent(float hpCurrent) {
        this.currentHp = hpCurrent;
    }

    public float getHpCurrentFactor() {
        return this.currentHp / (float)this.satelliteGrid.hullpoints;
    }

    public TankSystem getTankSystem() {
        if (this.tankSystemTemp == null) {
            this.tankSystemTemp = this.getSystem(TankSystem.class);
        }
        return this.tankSystemTemp;
    }

    public boolean hasTank(String resourceID) {
        if (this.tankSystemTemp == null) {
            this.tankSystemTemp = this.getSystem(TankSystem.class);
        }
        return this.tankSystemTemp.hasTank(resourceID);
    }

    public float getTankMax(String resourceID) {
        if (this.tankSystemTemp == null) {
            this.tankSystemTemp = this.getSystem(TankSystem.class);
        }
        return this.tankSystemTemp.getTankManager().getCompartment(resourceID).getMax();
    }

    public float getTankCurrentFactor(String resourceID) {
        if (this.tankSystemTemp == null) {
            this.tankSystemTemp = this.getSystem(TankSystem.class);
        }
        return this.tankSystemTemp.getTankManager().getCompartment(resourceID).getStoredFactor();
    }

    public float getTankCurrent(String resourceID) {
        if (this.tankSystemTemp == null) {
            this.tankSystemTemp = this.getSystem(TankSystem.class);
        }
        return this.tankSystemTemp.getTankManager().getCompartment(resourceID).getStored();
    }

    public float getFuelMax() {
        return this.getTankMax("resource_rocketFuel");
    }

    public float getFuelCurrentFactor() {
        return this.getTankCurrentFactor("resource_rocketFuel");
    }

    public float getOxygenMax() {
        return this.getTankMax("resource_oxygen");
    }

    public float getOxygenCurrentFactor() {
        return this.getTankCurrentFactor("resource_oxygen");
    }

    public Cargobay getInventory() {
        return null;
    }

    public static enum SimulationMode {
        PLAYER,
        NPC,
        NONE;

    }
}

