/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.satellite;

import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.DataContext;
import com.neutronio.astrax.app.datapack.DataPack;
import com.neutronio.astrax.app.datapack.EntityID;
import com.neutronio.astrax.app.datapack.game.world.NPCFactory;
import com.neutronio.astrax.app.datapack.game.world.NPCTrader;
import com.neutronio.astrax.app.datapack.game.world.SatelliteTarget;
import com.neutronio.astrax.app.datapack.game.world.galaxy.MerchantCreationSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.MerchantGenerationSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.MerchantGenerationSettingsRepository;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteGrid;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SavedModule;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SavedSatellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.FunctionalSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.Module;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.SatelliteModuleFactory;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.CargoSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.Cargobay;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.docking.Docker;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.docking.DockingSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.mining.MiningDrill;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.mining.MiningSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.propulsion.PropulsionSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.propulsion.Thruster;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors.MonitoringSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors.SensorSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.tanks.TankSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.DiscoverySystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.trade.MarketPlace;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.trade.MarketSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.trade.TradeSystem;
import com.neutronio.astrax.app.generator.AbstractFactory;
import com.neutronio.astrax.app.generator.ForNameSpace;
import com.neutronio.astrax.app.generator.GenericFactory;
import com.neutronio.astrax.app.generator.NameSpace;
import com.neutronio.astrax.app.generator.TargetFactory;
import com.neutronio.astrax.editor.placement.Orientation;
import com.neutronio.astrax.gfx.SatelliteGraphics;
import com.neutronio.astrax.gfx.factories.SatelliteGraphicsFactory;
import com.neutronio.astrax.io.AstraXFiles;
import com.neutronio.astrax.io.BlueprintLoader;
import com.neutronio.astrax.util.Vector2i;
import com.neutronio.astrax.util.collections.ProbabilitySet;
import com.neutronio.astrax.util.dummy.DummyTrader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

@ForNameSpace(value="craft")
public class SatelliteFactory
extends AbstractFactory
implements GenericFactory<Satellite, SatelliteGrid>,
TargetFactory<SatelliteTarget, SatelliteSettings> {
    private BlueprintLoader blueprintLoader = new BlueprintLoader();
    protected SatelliteGraphicsFactory satelliteGraphicsFactory;
    protected SatelliteModuleFactory satelliteModuleFactory;

    public SatelliteFactory() {
    }

    public SatelliteFactory(DataContext dataContext) {
        super(dataContext);
        this.satelliteGraphicsFactory = dataContext.getFactory(SatelliteGraphicsFactory.class);
        this.satelliteModuleFactory = dataContext.getFactory(SatelliteModuleFactory.class);
    }

    @Override
    public void setDataPack(DataPack dataPack) {
        super.setDataPack(dataPack);
    }

    public SatelliteTarget create(String entityId, SavedSatellite savedSatellite) {
        SatelliteTarget satelliteTarget = null;
        Satellite satellite = this.convert(savedSatellite);
        SatelliteGraphics satelliteGraphics = this.satelliteGraphicsFactory.createGraphics(satellite.satelliteGrid);
        satelliteTarget = new SatelliteTarget(new EntityID(entityId), satellite, satelliteGraphics);
        satellite.getSystem(DiscoverySystem.class).getProximitySensor().setParentTarget(satelliteTarget);
        if (satellite.hasSystem(PropulsionSystem.class)) {
            satellite.getSystem(PropulsionSystem.class).setListener(satelliteGraphics);
        }
        if (satellite.hasSystem(DiscoverySystem.class)) {
            ((Satellite)satelliteTarget.getModel()).getSystem(DiscoverySystem.class).setParentTarget(satelliteTarget);
        }
        return satelliteTarget;
    }

    public Satellite convert(SavedSatellite savedSatellite) {
        this.logger.fine("Creating satellite with current seed " + this.numberGenerator.getSeed());
        Satellite satellite = new Satellite();
        satellite.setName(savedSatellite.name);
        satellite.setHpCurrent(savedSatellite.currentHp);
        satellite.setSatelliteGridFile(savedSatellite.satelliteGridFile);
        try {
            satellite.satelliteGrid = this.blueprintLoader.load(savedSatellite.satelliteGridFile.path, savedSatellite.satelliteGridFile.location);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        TradeSystem tradeSystem = this.createOrGetSystem(TradeSystem.class, "Trade System", satellite);
        for (Map.Entry<Vector2i, SavedModule> entry : savedSatellite.modules.entrySet()) {
            Module module = this.satelliteModuleFactory.create(entry.getValue());
            module.setLocation(entry.getKey());
            this.attachModuleToSystems(satellite, module, module.getOrientation());
            if (module.getModuleSettings().marketSettings != null) {
                MarketPlace marketPlace = module.getFunctionality(MarketPlace.class);
                tradeSystem.addMarketPlace(marketPlace);
            }
            satellite.addModule(module);
        }
        CargoSystem system = satellite.getSystem(CargoSystem.class);
        tradeSystem.setCargoSystem(satellite.getSystem(CargoSystem.class));
        tradeSystem.setTrader(new DummyTrader("Spacecraft", 1200.0f, system.getMaxWeight()));
        MonitoringSystem monitoringSystem = satellite.getSystem(MonitoringSystem.class);
        if (monitoringSystem != null) {
            monitoringSystem.initializeAlerts();
        }
        TankSystem tankSystem = satellite.getSystem(TankSystem.class);
        tankSystem.calculateTankDistribution();
        return satellite;
    }

    @Override
    public SatelliteTarget createTarget(SatelliteSettings satelliteSettings) {
        SatelliteGrid satelliteGrid = null;
        try {
            String spacecraftName = null;
            spacecraftName = satelliteSettings.name != null ? satelliteSettings.name : (satelliteSettings.namePattern != null ? this.generateName(satelliteSettings.namePattern) : this.generateName());
            satelliteGrid = this.blueprintLoader.load(satelliteSettings.fileLocation.path, satelliteSettings.fileLocation.location);
            SatelliteTarget satelliteTarget = this.createTarget(spacecraftName, satelliteSettings.fileLocation, satelliteGrid);
            if (satelliteSettings.possibleMerchants != null) {
                this.generateMerchantFor(satelliteTarget, satelliteSettings.possibleMerchants);
            } else {
                this.logger.warning("Could not generate merchant for satellite: " + satelliteTarget.getID() + ": Probability Set is missing. Is this intended?");
            }
            return satelliteTarget;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public SatelliteTarget createTarget(String spacecraftName, AstraXFiles.AstraXFile gridSourceFile, SatelliteGrid satelliteGrid) {
        try {
            satelliteGrid = this.blueprintLoader.load(gridSourceFile.path, gridSourceFile.location);
            Satellite satellite = this.create(satelliteGrid);
            satellite.setSatelliteGridFile(gridSourceFile);
            SatelliteGraphics satelliteGraphics = this.satelliteGraphicsFactory.createGraphics(satelliteGrid);
            SatelliteTarget satelliteTarget = new SatelliteTarget(this.entityIDFactory.createID(this.numberGenerator), satellite, satelliteGraphics);
            satellite.getSystem(DiscoverySystem.class).getProximitySensor().setParentTarget(satelliteTarget);
            satelliteTarget.setNameSpace(new NameSpace("satellite", satelliteGrid.name, satelliteGrid.vesselSize.name()));
            if (spacecraftName != null) {
                satellite.setName(spacecraftName);
            }
            if (satellite.hasSystem(PropulsionSystem.class)) {
                satellite.getSystem(PropulsionSystem.class).setListener(satelliteGraphics);
            }
            if (satellite.hasSystem(DiscoverySystem.class)) {
                ((Satellite)satelliteTarget.getModel()).getSystem(DiscoverySystem.class).setParentTarget(satelliteTarget);
            }
            return satelliteTarget;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Satellite create(SatelliteGrid satelliteGrid) {
        this.logger.fine("Creating satellite with current seed " + this.numberGenerator.getSeed());
        Satellite satellite = new Satellite();
        TradeSystem tradeSystem = this.createOrGetSystem(TradeSystem.class, "Trade System", satellite);
        for (int x = 0; x < satelliteGrid.getData().getWidth() + 1; ++x) {
            for (int y = 0; y < satelliteGrid.getData().getHeight() + 1; ++y) {
                SatelliteGrid.SatelliteGridSettings settings = satelliteGrid.getData().get(x, y);
                if (settings == null) continue;
                Module module = this.satelliteModuleFactory.create(settings.moduleSettings);
                module.setOrientation(settings.orientation);
                module.setLocation(new Vector2i(x, y));
                this.attachModuleToSystems(satellite, module, settings.orientation);
                if (settings.moduleSettings.marketSettings != null) {
                    MarketPlace marketPlace = module.getFunctionality(MarketPlace.class);
                    tradeSystem.addMarketPlace(marketPlace);
                }
                satellite.addModule(module);
            }
        }
        satellite.setSatelliteGrid(satelliteGrid);
        satellite.setHpCurrent(satelliteGrid.hullpoints);
        satellite.setName(this.generateName());
        CargoSystem system = satellite.getSystem(CargoSystem.class);
        tradeSystem.setCargoSystem(satellite.getSystem(CargoSystem.class));
        tradeSystem.setTrader(new DummyTrader("Spacecraft", 1200.0f, system.getMaxWeight()));
        MonitoringSystem monitoringSystem = satellite.getSystem(MonitoringSystem.class);
        if (monitoringSystem != null) {
            monitoringSystem.initializeAlerts();
        }
        TankSystem tankSystem = satellite.getSystem(TankSystem.class);
        tankSystem.calculateTankDistribution();
        return satellite;
    }

    private <T extends FunctionalSystem> T createOrGetSystem(Class<T> type, String name, Satellite satellite) {
        FunctionalSystem system = null;
        if (!satellite.hasSystem(type)) {
            try {
                Constructor<T> constructor = type.getConstructor(String.class, Satellite.class);
                system = (FunctionalSystem)constructor.newInstance(name, satellite);
                satellite.addSystem(system);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else {
            system = (FunctionalSystem)satellite.getSystem(type);
        }
        return (T)system;
    }

    private void attachModuleToSystems(Satellite satellite, Module module, Orientation orientation) {
        if (module.getModuleSettings().thrusterSettings != null) {
            Thruster thruster = module.getFunctionality(Thruster.class);
            thruster.setAngle(orientation.getRotationDegrees());
            satellite.registerThruster(thruster);
            PropulsionSystem propulsionSystem = this.createOrGetSystem(PropulsionSystem.class, "Propulsion System", satellite);
            propulsionSystem.addToControlGroup(orientation.getControlGroup(), module);
            TankSystem tankSystem = this.createOrGetSystem(TankSystem.class, "Tank System", satellite);
            tankSystem.addModule(module);
        }
        if (module.getModuleSettings().tankSettings != null || module.getModuleSettings().energySettings != null) {
            TankSystem tankSystem = this.createOrGetSystem(TankSystem.class, "Tank System", satellite);
            tankSystem.addModule(module);
        }
        if (module.getModuleSettings().cockpitSettings != null) {
            DiscoverySystem discoverySystem = this.createOrGetSystem(DiscoverySystem.class, "Discovery System", satellite);
            SensorSystem sensorSystem = this.createOrGetSystem(SensorSystem.class, "Sensor System", satellite);
            discoverySystem.getProximitySensor().setMaxRange(module.getModuleSettings().cockpitSettings.sensorRange);
            MonitoringSystem monitoringSystem = this.createOrGetSystem(MonitoringSystem.class, "Monitoring System", satellite);
        }
        if (module.getModuleSettings().dockerSettings != null) {
            Docker docker = module.getFunctionality(Docker.class);
            DockingSystem system = this.createOrGetSystem(DockingSystem.class, "Docking System", satellite);
            system.addDocker(docker);
        }
        if (module.getModuleSettings().drillSettings != null) {
            module.stopModule();
            MiningSystem miningSystem = this.createOrGetSystem(MiningSystem.class, "Mining System", satellite);
            miningSystem.addMiningDrill(module);
            satellite.registerMiningDrill(module.getFunctionality(MiningDrill.class));
        }
        if (module.getModuleSettings().quarterSettings != null) {
            this.logger.warning("Quarter System not yet implemented!");
        }
        if (module.getModuleSettings().cargoSettings != null) {
            CargoSystem cargoSystem = this.createOrGetSystem(CargoSystem.class, "Cargo System", satellite);
            cargoSystem.addCargobay(module.getFunctionality(Cargobay.class));
        }
    }

    private void generateMerchantFor(SatelliteTarget satellite, ProbabilitySet<String> possibleMerchants) {
        NPCFactory npcFactory = AstraXApp.astraX.getFactoryByClass(NPCFactory.class);
        String randomMerchant = this.setGenerator.generate(this.numberGenerator, possibleMerchants);
        MerchantGenerationSettingsRepository repository = AstraXApp.astraX.getRepository(MerchantGenerationSettingsRepository.class);
        MerchantGenerationSettings merchant = (MerchantGenerationSettings)repository.find(randomMerchant);
        MerchantCreationSettings createdMerchant = npcFactory.generate(merchant);
        NPCTrader npcTrader = npcFactory.create(createdMerchant, ((Satellite)satellite.getModel()).getSystem(CargoSystem.class));
        TradeSystem tradeSystem = ((Satellite)satellite.getModel()).getSystem(TradeSystem.class);
        tradeSystem.setTrader(npcTrader);
        npcTrader.getMerchant().entityId = satellite.getID().get();
    }

    @Deprecated
    private void createMerchant(MarketPlace marketPlace) {
        NPCFactory npcFactory = AstraXApp.astraX.getFactoryByClass(NPCFactory.class);
        String randomMerchant = this.setGenerator.generate(this.numberGenerator, ((MarketSettings)marketPlace.getSettings()).possibleTraders);
        MerchantGenerationSettingsRepository repository = AstraXApp.astraX.getRepository(MerchantGenerationSettingsRepository.class);
        MerchantGenerationSettings merchant = (MerchantGenerationSettings)repository.find(randomMerchant);
        MerchantCreationSettings createdMerchant = npcFactory.generate(merchant);
        marketPlace.addTrader(npcFactory.create(createdMerchant));
    }

    @Override
    public SatelliteTarget createShuffledTarget(NameSpace nameSpace) {
        return null;
    }
}

