/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.satellite;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Rectangle;
import com.neutronio.astrax.app.CreationSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteRole;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.ModuleFunction;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.ModuleSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.CargoSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.docking.DockerSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.docking.VesselSize;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.propulsion.TankSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.propulsion.ThrusterSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.quarters.QuarterSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors.CockpitSettings;
import com.neutronio.astrax.editor.overlays.SatelliteStatistics;
import com.neutronio.astrax.editor.placement.Orientation;
import com.neutronio.astrax.util.Vector2i;
import com.neutronio.astrax.util.collections.Grid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SatelliteGrid
implements CreationSettings {
    public String name;
    public SatelliteRole vesselRole;
    public VesselSize vesselSize;
    public int hullpoints;
    public float weight;
    public float value;
    private Grid<SatelliteGridSettings> data = null;
    public transient CargoSettings cargoSettings = new CargoSettings();
    public transient QuarterSettings quarterSettings = new QuarterSettings();
    public transient CockpitSettings cockpitSettings = new CockpitSettings();
    public transient List<DockerSettings> dockingSettings = new ArrayList<DockerSettings>();
    public transient Map<String, TankSettings> tankSettings = new HashMap<String, TankSettings>();
    public transient Map<String, ThrusterSettings> thrusterSettings = new HashMap<String, ThrusterSettings>();
    public SatelliteStatistics statistics = new SatelliteStatistics();

    public SatelliteGrid(SatelliteRole vesselRole, VesselSize vesselSize) {
        this.data = new Grid(vesselSize.width, vesselSize.height);
        this.vesselSize = vesselSize;
        this.vesselRole = vesselRole;
    }

    public void clearData() {
        this.name = "";
        this.hullpoints = 0;
        this.weight = 0.0f;
        this.value = 0.0f;
        this.cargoSettings = new CargoSettings();
        this.quarterSettings = new QuarterSettings();
        this.tankSettings = new HashMap<String, TankSettings>();
        this.thrusterSettings = new HashMap<String, ThrusterSettings>();
        this.data.clear();
    }

    public void placeData(int xTile, int yTile, SatelliteGridSettings settings) {
        this.data.place(xTile, yTile, settings);
        this.hullpoints += settings.moduleSettings.hullpoints;
        this.weight += settings.moduleSettings.weight;
        this.value += settings.moduleSettings.value;
        if (settings.moduleSettings.weight > this.statistics.maxWeight.floatValue()) {
            this.statistics.maxWeight = Float.valueOf(settings.moduleSettings.weight);
        }
        if (settings.moduleSettings.value > this.statistics.maxValue.floatValue()) {
            this.statistics.maxValue = Float.valueOf(settings.moduleSettings.value);
        }
        if (settings.moduleSettings.hullpoints > this.statistics.maxHullpoints) {
            this.statistics.maxHullpoints = settings.moduleSettings.hullpoints;
        }
        if (settings.moduleSettings.cargoSettings != null) {
            this.cargoSettings.maxWeight += settings.moduleSettings.cargoSettings.maxWeight;
        }
        if (settings.moduleSettings.energySettings != null) {
            this.combineTankSettings(true, settings.moduleSettings.energySettings.fuelType, settings.moduleSettings.energySettings);
        }
        if (settings.moduleSettings.quarterSettings != null) {
            this.quarterSettings.beds += settings.moduleSettings.quarterSettings.beds;
            this.quarterSettings.comfort += settings.moduleSettings.quarterSettings.comfort;
        }
        if (settings.moduleSettings.tankSettings != null) {
            this.combineTankSettings(true, settings.moduleSettings.tankSettings.fuelType, settings.moduleSettings.tankSettings);
        }
        if (settings.moduleSettings.thrusterSettings != null) {
            this.combineThrusterSettings(true, settings.moduleSettings.thrusterSettings.fuelType, settings.moduleSettings.thrusterSettings);
        }
        if (settings.moduleSettings.cockpitSettings != null) {
            this.cockpitSettings.sensorRange = Math.max(this.cockpitSettings.sensorRange, settings.moduleSettings.cockpitSettings.sensorRange);
            this.cockpitSettings.amountInstantTargets = Math.max(this.cockpitSettings.amountInstantTargets, settings.moduleSettings.cockpitSettings.amountInstantTargets);
            this.cockpitSettings.cockpitSeats += settings.moduleSettings.cockpitSettings.cockpitSeats;
        }
        if (settings.moduleSettings.dockerSettings != null) {
            this.dockingSettings.add(settings.moduleSettings.dockerSettings);
        }
    }

    public SatelliteGridSettings eraseData(int xTile, int yTile) {
        SatelliteGridSettings settings = this.data.get(xTile, yTile);
        if (settings != null) {
            this.data.erase(xTile, yTile);
            this.hullpoints -= settings.moduleSettings.hullpoints;
            this.weight -= settings.moduleSettings.weight;
            this.value -= settings.moduleSettings.value;
            if (settings.moduleSettings.cargoSettings != null) {
                this.cargoSettings.maxWeight -= settings.moduleSettings.cargoSettings.maxWeight;
            }
            if (settings.moduleSettings.quarterSettings != null) {
                this.quarterSettings.beds -= settings.moduleSettings.quarterSettings.beds;
                this.quarterSettings.comfort -= settings.moduleSettings.quarterSettings.comfort;
            }
            if (settings.moduleSettings.tankSettings != null) {
                this.combineTankSettings(false, settings.moduleSettings.tankSettings.fuelType, settings.moduleSettings.tankSettings);
            }
            if (settings.moduleSettings.thrusterSettings != null) {
                this.combineThrusterSettings(false, settings.moduleSettings.thrusterSettings.fuelType, settings.moduleSettings.thrusterSettings);
            }
        }
        return settings;
    }

    private void combineThrusterSettings(boolean add, String fuelType, ThrusterSettings thrusterSettings) {
        ThrusterSettings storedSettings = this.thrusterSettings.get(thrusterSettings.fuelType);
        if (storedSettings == null) {
            ThrusterSettings addedSettings = new ThrusterSettings();
            addedSettings.fuelType = thrusterSettings.fuelType;
            if (add) {
                addedSettings.add(thrusterSettings);
            } else {
                addedSettings.subtract(thrusterSettings);
            }
            this.thrusterSettings.put(fuelType, addedSettings);
        } else if (add) {
            storedSettings.add(thrusterSettings);
        } else {
            storedSettings.subtract(thrusterSettings);
        }
    }

    private void combineTankSettings(boolean add, String fuelType, TankSettings tankSettings) {
        TankSettings storedSettings = this.tankSettings.get(tankSettings.fuelType);
        if (storedSettings == null) {
            TankSettings addedSettings = new TankSettings();
            addedSettings.fuelType = tankSettings.fuelType;
            if (add) {
                addedSettings.add(tankSettings);
            } else {
                addedSettings.subtract(tankSettings);
            }
            this.tankSettings.put(fuelType, addedSettings);
        } else if (add) {
            storedSettings.add(tankSettings);
        } else {
            storedSettings.subtract(tankSettings);
        }
    }

    public Grid<SatelliteGridSettings> getData() {
        return this.data;
    }

    public Set<String> getTankTypes() {
        return this.tankSettings.keySet();
    }

    public Rectangle getDimension() {
        Rectangle result = new Rectangle();
        Vector2i min = new Vector2i(Integer.MAX_VALUE, Integer.MAX_VALUE);
        Vector2i max = new Vector2i(Integer.MIN_VALUE, Integer.MIN_VALUE);
        for (int x = 0; x < this.data.getWidth() + 1; ++x) {
            for (int y = 0; y < this.data.getHeight() + 1; ++y) {
                SatelliteGridSettings settings = this.data.get(x, y);
                if (settings == null) continue;
                if (x < min.x) {
                    min.x = x;
                }
                if (x > max.x) {
                    max.x = x;
                }
                if (y < min.y) {
                    min.y = y;
                }
                if (y <= max.y) continue;
                max.y = y;
            }
        }
        result.set(min.x, min.y, max.x - min.x + 1, max.y - min.y + 1);
        return result;
    }

    public static class SatelliteGridSettings
    implements CreationSettings {
        public ModuleSettings moduleSettings;
        public Orientation orientation;
        public Color tint = Color.WHITE;
        public ModuleFunction module;

        public SatelliteGridSettings(ModuleSettings moduleSettings, Orientation orientation, Color tint) {
            this.moduleSettings = moduleSettings;
            this.orientation = orientation;
            this.tint = tint == null ? Color.WHITE : tint;
        }
    }
}

