/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.satellite;

import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SavedModuleFunction;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.Module;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.ModuleFunction;
import com.neutronio.astrax.editor.placement.Orientation;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class SavedModule
implements Serializable {
    private static final long serialVersionUID = 1218037070958627976L;
    public int hullpoints;
    public String name;
    public float weight;
    public String moduleSettingsID;
    public Orientation orientation;
    public Module.ModuleStatus status = Module.ModuleStatus.RUNNING;
    public List<SavedModuleFunction> functionality = new ArrayList<SavedModuleFunction>();

    public SavedModule() {
    }

    public SavedModule(Module module) {
        this.name = module.getName();
        this.hullpoints = module.getHullpoints();
        this.weight = module.getWeight();
        this.status = module.getStatus();
        this.moduleSettingsID = module.getModuleSettings().id;
        this.orientation = module.getOrientation();
        for (ModuleFunction moduleFunction : module.getTankFunctionality()) {
            this.functionality.add(new SavedModuleFunction(moduleFunction));
        }
        for (ModuleFunction moduleFunction : module.getFunctionality()) {
            this.functionality.add(new SavedModuleFunction(moduleFunction));
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeUTF(this.name);
        oos.writeUTF(this.moduleSettingsID);
        oos.writeInt(this.hullpoints);
        oos.writeFloat(this.weight);
        oos.writeInt(this.orientation.ordinal());
        oos.writeInt(this.status.ordinal());
        oos.writeInt(this.functionality.size());
        for (SavedModuleFunction savedModuleFunction : this.functionality) {
            oos.writeObject(savedModuleFunction);
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        this.name = ois.readUTF();
        this.moduleSettingsID = ois.readUTF();
        this.hullpoints = ois.readInt();
        this.weight = ois.readFloat();
        this.orientation = Orientation.values()[ois.readInt()];
        this.status = Module.ModuleStatus.values()[ois.readInt()];
        this.functionality = new ArrayList<SavedModuleFunction>();
        int size = ois.readInt();
        for (int i2 = 0; i2 < size; ++i2) {
            this.functionality.add((SavedModuleFunction)ois.readObject());
        }
    }
}

