/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.satellite;

import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.mechanics.resources.Resource;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.ModuleFunctionSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.ModuleFunction;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.Tank;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.Cargobay;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.InventoryUtils;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.Item;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.mining.MiningDrill;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.propulsion.Thruster;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.trade.MarketPlace;
import com.neutronio.astrax.util.Vector2i;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class SavedModuleFunction
implements Serializable {
    public static final long serialVersionUID = 8261370195783838228L;
    public String className;
    public Vector2i location;
    public ModuleFunctionSettings settings;
    public String inventoryName;
    public List<Item<Resource>> inventoryItems;
    public float drillMiningTimer;
    public float thrusterCurrentThrust;
    public float thrusterTargetThrust;
    public boolean thrusterRunning;
    public float tankStored;
    public String tankStoredID;
    public List<Object> traders;

    public SavedModuleFunction() {
    }

    public SavedModuleFunction(ModuleFunction function) {
        this.location = function.getLocation().copy();
        this.className = function.getClass().getCanonicalName();
        this.settings = function.getSettings();
        if (function instanceof Cargobay) {
            Cargobay inventory = (Cargobay)function;
            this.inventoryName = inventory.getName();
            this.inventoryItems = inventory.getAllItems();
        } else if (function instanceof MiningDrill) {
            MiningDrill drill = (MiningDrill)function;
            this.drillMiningTimer = drill.getMiningTimer();
        } else if (function instanceof Thruster) {
            Thruster thruster = (Thruster)function;
            this.thrusterCurrentThrust = thruster.getCurrentThrust();
            this.thrusterTargetThrust = thruster.getTargetThrust();
            this.thrusterRunning = thruster.isRunning();
        } else if (function instanceof Tank) {
            Tank tank = (Tank)function;
            this.tankStored = tank.getStored();
            this.tankStoredID = tank.getUsedResourceID();
        } else if (function instanceof MarketPlace) {
            // empty if block
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeUTF(this.className);
        oos.writeObject(this.location);
        oos.writeObject(this.settings);
        if (this.className.equals(Cargobay.class.getCanonicalName())) {
            if (this.inventoryItems == null && this.inventoryName == null) {
                oos.writeObject(null);
            } else {
                oos.writeInt(this.inventoryItems.size());
                for (Item<Resource> item : this.inventoryItems) {
                    oos.writeUTF(item.getObject().id);
                    oos.writeFloat(item.getAmount());
                }
                oos.writeUTF(this.inventoryName);
            }
        }
        if (this.className.equals(MiningDrill.class.getCanonicalName())) {
            oos.writeFloat(this.drillMiningTimer);
        }
        if (this.className.equals(Thruster.class.getCanonicalName())) {
            oos.writeFloat(this.thrusterCurrentThrust);
            oos.writeFloat(this.thrusterTargetThrust);
            oos.writeBoolean(this.thrusterRunning);
        }
        if (this.className.equals(Tank.class.getCanonicalName())) {
            oos.writeUTF(this.tankStoredID);
            oos.writeFloat(this.tankStored);
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        Integer size;
        this.className = ois.readUTF();
        this.location = (Vector2i)ois.readObject();
        this.settings = (ModuleFunctionSettings)ois.readObject();
        if (this.className.equals(Cargobay.class.getCanonicalName()) && (size = Integer.valueOf(ois.readInt())) != null) {
            this.inventoryItems = new ArrayList<Item<Resource>>();
            for (int i2 = 0; i2 < size; ++i2) {
                String resourceID = ois.readUTF();
                float amount = ois.readFloat();
                Resource resource = (Resource)AstraXApp.astraX.findResource(resourceID);
                this.inventoryItems.add(InventoryUtils.resourceToItem(resource, amount));
            }
            this.inventoryName = ois.readUTF();
        }
        if (this.className.equals(MiningDrill.class.getCanonicalName())) {
            this.drillMiningTimer = ois.readFloat();
        }
        if (this.className.equals(Thruster.class.getCanonicalName())) {
            this.thrusterCurrentThrust = ois.readFloat();
            this.thrusterTargetThrust = ois.readFloat();
            this.thrusterRunning = ois.readBoolean();
        }
        if (this.className.equals(Tank.class.getCanonicalName())) {
            this.tankStoredID = ois.readUTF();
            this.tankStored = ois.readFloat();
        }
    }
}

