/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.satellite;

import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SavedModule;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.Module;
import com.neutronio.astrax.io.AstraXFiles;
import com.neutronio.astrax.io.FileHandler;
import com.neutronio.astrax.util.Vector2i;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public class SavedSatellite
implements Serializable {
    private static final long serialVersionUID = -5643104398423947130L;
    public String name = "";
    public float currentHp = 0.0f;
    public AstraXFiles.AstraXFile satelliteGridFile = new AstraXFiles.AstraXFile(null, "", FileHandler.FileLocation.LOCAL);
    public Map<Vector2i, SavedModule> modules = new LinkedHashMap<Vector2i, SavedModule>();

    public SavedSatellite() {
    }

    public SavedSatellite(Satellite satellite) {
        if (satellite.getSatelliteGridFile() == null) {
            throw new AstraXException(AstraXException.ErrorCode.E0001, "Satellite Grid File missing");
        }
        this.name = satellite.getName();
        this.currentHp = satellite.getHpCurrent();
        this.satelliteGridFile = satellite.getSatelliteGridFile();
        for (Module module : satellite.getModules()) {
            if (this.modules.containsKey(module.getLocation())) {
                new AstraXException(AstraXException.ErrorCode.E0004, "Module already exists at location " + module.getLocation());
            }
            this.modules.put(module.getLocation(), new SavedModule(module));
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeUTF(this.name);
        oos.writeFloat(this.currentHp);
        oos.writeObject(this.satelliteGridFile);
        oos.writeInt(this.modules.size());
        for (Map.Entry<Vector2i, SavedModule> entry : this.modules.entrySet()) {
            if (entry.getKey() == null) {
                throw new AstraXException(AstraXException.ErrorCode.E2001, "Module location inside the satellite grid must be set! Please ensure the modules are created properly");
            }
            oos.writeObject(entry.getKey());
            oos.writeObject(entry.getValue());
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        this.name = ois.readUTF();
        this.currentHp = ois.readFloat();
        this.satelliteGridFile = (AstraXFiles.AstraXFile)ois.readObject();
        int size = ois.readInt();
        this.modules = new LinkedHashMap<Vector2i, SavedModule>();
        for (int i2 = 0; i2 < size; ++i2) {
            Vector2i location = (Vector2i)ois.readObject();
            SavedModule savedModule = (SavedModule)ois.readObject();
            this.modules.put(location, savedModule);
        }
    }
}

