/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems;

import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.ModuleFunction;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.ModuleSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.Tank;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.Cargobay;
import com.neutronio.astrax.editor.placement.Orientation;
import com.neutronio.astrax.util.Vector2i;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Module {
    protected int hullpoints;
    protected float durability;
    protected String name;
    protected float weight;
    protected ModuleSettings moduleSettings;
    protected Vector2i location = null;
    protected Orientation orientation;
    protected Map<Class, ModuleFunction> functionality = new HashMap<Class, ModuleFunction>();
    protected ModuleStatus status = ModuleStatus.RUNNING;
    protected ModuleListener listener;
    protected Map<String, Tank> tankCompartments = new HashMap<String, Tank>();

    public Module(ModuleSettings moduleSettings) {
        this.hullpoints = moduleSettings.hullpoints;
        this.name = moduleSettings.name;
        this.weight = moduleSettings.weight;
        this.moduleSettings = moduleSettings;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public Vector2i getLocation() {
        return this.location;
    }

    public void setLocation(Vector2i location) {
        this.location = location;
    }

    public void setListener(ModuleListener listener) {
        this.listener = listener;
    }

    public int getHullpoints() {
        return this.hullpoints;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void startModule() {
        if (!Objects.equals((Object)this.status, (Object)ModuleStatus.DEFECT)) {
            this.status = ModuleStatus.RUNNING;
            if (this.listener != null) {
                this.listener.onStart(this);
            }
        }
    }

    public void stopModule() {
        if (!Objects.equals((Object)this.status, (Object)ModuleStatus.DEFECT)) {
            this.status = ModuleStatus.STOPPED;
            if (this.listener != null) {
                this.listener.onStop(this);
            }
        }
    }

    public ModuleStatus getStatus() {
        return this.status;
    }

    public boolean isRunning() {
        return Objects.equals((Object)this.status, (Object)ModuleStatus.RUNNING);
    }

    public boolean isDefect() {
        return Objects.equals((Object)this.status, (Object)ModuleStatus.DEFECT);
    }

    public ModuleSettings getModuleSettings() {
        return this.moduleSettings;
    }

    public void addFunctionality(ModuleFunction functionality) {
        if (functionality == null) {
            return;
        }
        functionality.setParent(this);
        if (functionality instanceof Tank) {
            Tank tank = (Tank)functionality;
            this.tankCompartments.put(tank.getUsedResourceID(), tank);
        } else {
            this.functionality.put(functionality.getClass(), functionality);
        }
    }

    public <T extends ModuleFunction> T getFunctionality(Class<T> functionality) {
        return (T)this.functionality.get(functionality);
    }

    public <T extends ModuleFunction> boolean hasFunctionality(Class<T> functionality) {
        return this.functionality.containsKey(functionality);
    }

    public Collection<ModuleFunction> getFunctionality() {
        return this.functionality.values();
    }

    public <T extends Tank> T getTankFunctionality(String forResource) {
        return (T)this.tankCompartments.get(forResource);
    }

    public Collection<Tank> getTankFunctionality() {
        return this.tankCompartments.values();
    }

    @Deprecated
    public boolean hasTank(String resourceID) {
        return this.tankCompartments.containsKey(resourceID);
    }

    public float getWeight() {
        if (this.hasFunctionality(Cargobay.class)) {
            return this.weight + this.getFunctionality(Cargobay.class).getWeight();
        }
        return this.weight;
    }

    public boolean hasTanks() {
        return !this.tankCompartments.isEmpty();
    }

    public synchronized void update(float delta) {
        if (!this.isRunning()) {
            return;
        }
        for (ModuleFunction moduleFunction : this.functionality.values()) {
            moduleFunction.update(delta);
        }
    }

    public String toString() {
        return "Module{" + this.name + '}';
    }

    public static enum ModuleStatus {
        STOPPED,
        RUNNING,
        DEFECT;

    }

    public static interface ModuleListener {
        public void onStart(Module var1);

        public void onStop(Module var1);

        public void onDefect(Module var1);
    }
}

