/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems;

import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.DataContext;
import com.neutronio.astrax.app.datapack.game.mechanics.resources.Resource;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SavedModule;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SavedModuleFunction;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.Cockpit;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.Module;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.ModuleFunction;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.ModuleSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.Tank;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.Cargobay;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.docking.Docker;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.mining.MiningDrill;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.propulsion.Thruster;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.quarters.Quarters;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.trade.MarketPlace;
import com.neutronio.astrax.app.generator.AbstractFactory;
import com.neutronio.astrax.app.generator.GenericFactory;
import com.neutronio.astrax.app.repository.ResourceRepository;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;

public class SatelliteModuleFactory
extends AbstractFactory
implements GenericFactory<Module, ModuleSettings> {
    private ResourceRepository repository;

    public SatelliteModuleFactory() {
    }

    public SatelliteModuleFactory(DataContext dataContext) {
        super(dataContext);
        this.dataContext = dataContext;
        this.repository = this.dataContext.getRepository(ResourceRepository.class);
    }

    @Override
    public Module create(SavedModule savedModule) {
        Module module = new Module((ModuleSettings)AstraXApp.astraX.findResource(savedModule.moduleSettingsID));
        module.name = savedModule.name;
        module.status = savedModule.status;
        module.hullpoints = savedModule.hullpoints;
        module.weight = savedModule.weight;
        module.orientation = savedModule.orientation;
        for (SavedModuleFunction savedFunction : savedModule.functionality) {
            ModuleFunction moduleFunction = this.create(savedFunction);
            moduleFunction.setParent(module);
            module.addFunctionality(moduleFunction);
        }
        return module;
    }

    @Override
    public ModuleFunction create(SavedModuleFunction moduleFunction) {
        ModuleFunction function = null;
        Class<?> moduleClass = null;
        try {
            moduleClass = Class.forName(moduleFunction.className);
            function = (ModuleFunction)moduleClass.getConstructor(SavedModuleFunction.class).newInstance(moduleFunction);
            function.settings = moduleFunction.settings;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            this.logger.log(Level.SEVERE, "Unable to instantiate spacecraft module: " + moduleClass, e);
            e.printStackTrace();
        }
        return function;
    }

    @Override
    public Module create(ModuleSettings moduleSettings) {
        Module module = new Module(moduleSettings);
        if (moduleSettings.thrusterSettings != null) {
            Thruster thruster = new Thruster(this.entityIDFactory.createID(this.numberGenerator, Thruster.class.getSimpleName(), 5), moduleSettings.thrusterSettings);
            module.addFunctionality(thruster);
        }
        if (moduleSettings.tankSettings != null) {
            module.addFunctionality(new Tank(moduleSettings.tankSettings, (Resource)this.repository.find(moduleSettings.tankSettings.fuelType)));
        }
        if (moduleSettings.energySettings != null) {
            module.addFunctionality(new Tank(moduleSettings.energySettings, (Resource)this.repository.find(moduleSettings.energySettings.fuelType)));
        }
        if (moduleSettings.quarterSettings != null) {
            module.addFunctionality(new Quarters(this.entityIDFactory.createID(this.numberGenerator, Quarters.class.getSimpleName(), 5), moduleSettings.quarterSettings));
        }
        if (moduleSettings.cargoSettings != null) {
            Cargobay inventory = new Cargobay(moduleSettings.cargoSettings);
            inventory.setName(moduleSettings.name);
            module.addFunctionality(inventory);
        }
        if (moduleSettings.cockpitSettings != null) {
            module.addFunctionality(new Cockpit(this.entityIDFactory.createID(this.numberGenerator, Cockpit.class.getSimpleName(), 5), moduleSettings.cockpitSettings));
        }
        if (moduleSettings.dockerSettings != null) {
            module.addFunctionality(new Docker(this.entityIDFactory.createID(this.numberGenerator, Docker.class.getSimpleName(), 5), moduleSettings.dockerSettings));
        }
        if (moduleSettings.marketSettings != null) {
            module.addFunctionality(new MarketPlace(this.entityIDFactory.createID(this.numberGenerator, MarketPlace.class.getSimpleName(), 5), moduleSettings.marketSettings));
        }
        if (moduleSettings.drillSettings != null) {
            module.addFunctionality(new MiningDrill(this.entityIDFactory.createID(this.numberGenerator, MiningDrill.class.getSimpleName(), 5), moduleSettings.drillSettings));
            module.stopModule();
        }
        return module;
    }
}

