/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems;

import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.mechanics.resources.Resource;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SavedModuleFunction;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.ModuleFunction;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.InventoryUtils;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.Item;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.propulsion.TankSettings;

public class Tank
extends ModuleFunction<TankSettings> {
    private Resource storedResource;
    private float stored;

    public Tank() {
    }

    public Tank(SavedModuleFunction moduleFunction) {
        this.storedResource = (Resource)AstraXApp.astraX.findResource(moduleFunction.tankStoredID);
        this.stored = moduleFunction.tankStored;
        Item<Resource> resourceItem = InventoryUtils.resourceToItem((Resource)AstraXApp.astraX.findResource(moduleFunction.tankStoredID), moduleFunction.tankStored);
        this.settings = (TankSettings)moduleFunction.settings;
    }

    public Tank(TankSettings functionality) {
        super(functionality);
        this.storedResource = (Resource)AstraXApp.astraX.findResource(functionality.fuelType);
        this.stored = functionality.capacity;
    }

    public Resource getStoredResource() {
        return this.storedResource;
    }

    public void setStored(float stored) {
        this.stored = stored;
    }

    public Tank(TankSettings functionality, Resource resource) {
        super(functionality);
        this.storedResource = (Resource)AstraXApp.astraX.findResource(functionality.fuelType);
        this.stored = functionality.capacity;
    }

    @Override
    public String getUsedResourceID() {
        return ((TankSettings)this.settings).fuelType;
    }

    public boolean isEmpty() {
        return this.stored == 0.0f;
    }

    public float getCapacity() {
        return ((TankSettings)this.settings).capacity;
    }

    public float getStored() {
        return this.stored;
    }
}

