/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo;

import com.neutronio.astrax.app.datapack.game.mechanics.resources.Resource;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.FunctionalSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.Tank;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.Cargobay;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.InventoryUtils;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.Item;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.MultiStackInventory;
import com.neutronio.astrax.util.collections.GroupedMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class CargoSystem
extends FunctionalSystem<Satellite> {
    private List<Cargobay<Resource>> inventories = new ArrayList<Cargobay<Resource>>();
    private GroupedMap<String, Tank> tanks = new GroupedMap();

    public CargoSystem(String displayName, Satellite parent) {
        super(displayName, parent);
    }

    public int getInventoryCount() {
        return this.inventories.size();
    }

    public Cargobay getInventory(int index) {
        return this.inventories.get(index);
    }

    public MultiStackInventory<Resource> getAccumulatedInventory() {
        float maxWeight = 0.0f;
        for (Cargobay<Resource> cargobay : this.inventories) {
            maxWeight += cargobay.getMaxWeight();
        }
        Set<String> keys = this.tanks.getGroupKeys();
        for (String key : keys) {
            List<Tank> tankList = this.tanks.getElements(key);
            for (Tank tank : tankList) {
                maxWeight += tank.getStoredResource().weight * tank.getStored();
            }
        }
        MultiStackInventory<Resource> multiStackInventory = new MultiStackInventory<Resource>(maxWeight);
        for (Cargobay<Resource> inventory : this.inventories) {
            for (Item item : inventory.getAllItems()) {
                multiStackInventory.add(item);
            }
        }
        for (String key : keys) {
            List<Tank> tankList = this.tanks.getElements(key);
            for (Tank tank : tankList) {
                multiStackInventory.add(InventoryUtils.resourceToItem(tank.getStoredResource(), tank.getStored()));
            }
        }
        return multiStackInventory;
    }

    public void disableListenerEvents() {
        for (Cargobay<Resource> inventory : this.inventories) {
            inventory.setFireEvents(false);
        }
    }

    public void enableListenerEvents() {
        for (Cargobay<Resource> inventory : this.inventories) {
            inventory.setFireEvents(true);
        }
    }

    public void addTank(Tank tank) {
        if (tank == null) {
            return;
        }
        this.tanks.addToGroup(tank.getUsedResourceID(), tank);
    }

    public void addCargobay(Cargobay inventory) {
        if (inventory == null) {
            return;
        }
        if (this.inventories.contains(inventory)) {
            return;
        }
        this.inventories.add(inventory);
    }

    public List<Item<Resource>> findAllStacksOf(Resource resource) {
        ArrayList<Item<Resource>> stacks = new ArrayList<Item<Resource>>();
        for (Cargobay<Resource> inventory : this.inventories) {
            stacks.addAll(inventory.getAllStacksOf(resource));
        }
        return stacks;
    }

    public float remove(Resource resource, float amount) {
        float remainder = amount;
        if (((Satellite)this.getParent()).getTankSystem().hasTank(resource.id)) {
            remainder = ((Satellite)this.getParent()).getTankSystem().refill(resource.id, -amount);
        }
        if (remainder <= 0.0f) {
            return 0.0f;
        }
        for (Cargobay<Resource> inventory : this.inventories) {
            if (!inventory.contains(resource)) continue;
            remainder = inventory.remove(resource, remainder);
        }
        return remainder;
    }

    public void removeAll(List<Item<Resource>> items) {
        for (Item<Resource> item : items) {
            for (Cargobay<Resource> inventory : this.inventories) {
                if (!inventory.contains(item.getObject())) continue;
                inventory.remove(item.getObject(), item.getAmount());
            }
        }
    }

    public float add(Item<Resource> item) {
        float toAdd = item.getAmount();
        if (((Satellite)this.getParent()).getTankSystem().hasTank(item.getObject().id)) {
            toAdd = ((Satellite)this.getParent()).getTankSystem().refill(item.getObject().id, item.getAmount());
        }
        if (toAdd <= 0.0f) {
            return 0.0f;
        }
        for (Cargobay<Resource> inventory : this.inventories) {
            if (item.getAmount() == 0.0f) {
                return 0.0f;
            }
            toAdd = inventory.addWithRemainder(item);
            item.setAmount(Math.max(toAdd, 0.0f));
        }
        return toAdd;
    }

    public float addAll(List<Item<Resource>> items) {
        float notAdded = 0.0f;
        for (Item<Resource> item : items) {
            notAdded += this.add(item.copy());
        }
        return notAdded;
    }

    public List<Item<Resource>> getAllItems() {
        ArrayList<Item<Resource>> allIiems = new ArrayList<Item<Resource>>();
        for (Cargobay<Resource> inventory : this.inventories) {
            allIiems.addAll(inventory.getAllItems());
        }
        return allIiems;
    }

    public Item<Resource> getItemOf(Resource resource) {
        Item<Resource> stack = new Item<Resource>().withObject(resource);
        for (Cargobay<Resource> inventory : this.inventories) {
            Item<Resource> stackOf = inventory.getStackOf(resource);
            if (stackOf == null) continue;
            stack.setAmount(stack.getAmount() + stackOf.getAmount());
        }
        return stack;
    }

    public float calculateCurrentWeight() {
        float weight = 0.0f;
        for (Cargobay<Resource> inventory : this.inventories) {
            weight += inventory.getWeight();
        }
        return weight;
    }

    public void transferTo(CargoSystem destination, List<Item<Resource>> items) {
        ArrayList<Item<Resource>> surplus = new ArrayList<Item<Resource>>();
        for (Item<Resource> item : items) {
            Item<Resource> itemCopy = item.copy();
            float remainder = destination.add(itemCopy);
            this.remove(item.getObject(), item.getAmount() - remainder);
            surplus.add(itemCopy.withAmount(remainder));
        }
    }

    public boolean hasSpace(float weight) {
        return weight < this.getMaxWeight() - this.calculateCurrentWeight();
    }

    public float getMaxWeight() {
        if (this.getParent() != null) {
            return ((Satellite)this.getParent()).getSatelliteGrid().cargoSettings.maxWeight;
        }
        float weight = 0.0f;
        for (Cargobay<Resource> inventory : this.inventories) {
            weight += inventory.getMaxWeight();
        }
        return weight;
    }

    public float getCurrentWeight() {
        float weight = 0.0f;
        for (Cargobay<Resource> inventory : this.inventories) {
            weight += inventory.getWeight();
        }
        return weight;
    }

    @Override
    public void update(float delta) {
    }
}

