/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo;

import com.neutronio.astrax.app.datapack.game.mechanics.resources.Resource;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SavedModuleFunction;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.ModuleFunction;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.CargoSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.Inventory;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.InventoryListener;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.Item;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.ItemComparator;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.MultiStackInventory;
import java.util.List;

public class Cargobay<I>
extends ModuleFunction<CargoSettings>
implements Inventory<I> {
    private MultiStackInventory<I> inventory;

    public Cargobay(CargoSettings functionality) {
        super(functionality);
        this.inventory = new MultiStackInventory(functionality.maxWeight);
    }

    public Cargobay(SavedModuleFunction moduleFunction) {
        this.inventory = new MultiStackInventory(((CargoSettings)moduleFunction.settings).maxWeight);
        this.inventory.setName(moduleFunction.inventoryName);
        for (Item<Resource> item : moduleFunction.inventoryItems) {
            this.inventory.add(item);
        }
        this.updateValues();
    }

    public MultiStackInventory getInventory() {
        return this.inventory;
    }

    public void setFireEvents(boolean fireEvents) {
        this.inventory.setFireEvents(fireEvents);
    }

    @Override
    public InventoryListener<I> getListener() {
        return this.inventory.getListener();
    }

    @Override
    public void setListener(InventoryListener<I> listener) {
        this.inventory.setListener(listener);
    }

    @Override
    public String getName() {
        return this.inventory.getName();
    }

    public void setName(String name) {
        this.inventory.setName(name);
    }

    @Override
    public float getMaxWeight() {
        return ((CargoSettings)this.settings).maxWeight;
    }

    public List<Item<I>> getAllItems() {
        return this.inventory.getAllItems();
    }

    @Override
    public boolean canAddWeight(float weight) {
        return this.inventory.canAddWeight(weight);
    }

    @Override
    public boolean canAddAmount(float amount) {
        return this.inventory.canAddAmount(amount);
    }

    @Override
    public boolean canAdd(Item<I> item) {
        return this.inventory.canAdd(item);
    }

    public void addToStack(Item<I> item, float amount) {
        this.inventory.addToStack(item, amount);
    }

    public Item<I> get(int index) {
        return this.inventory.get(index);
    }

    @Override
    public float remove(Item<I> item) {
        return this.inventory.remove(item);
    }

    @Override
    public float remove(I object, float amount) {
        return this.inventory.remove(object, amount);
    }

    @Override
    public void add(Item<I> item) {
        this.inventory.add(item);
    }

    @Override
    public float addWithRemainder(Item<I> item) {
        return this.inventory.addWithRemainder(item);
    }

    @Override
    public boolean contains(Item<?> otherItem) {
        return this.contains(otherItem.getObject());
    }

    @Override
    public boolean contains(Object object) {
        return this.inventory.contains(object);
    }

    public Item<I> getStackOf(I object) {
        return this.inventory.getStackOf(object);
    }

    public List<Item<I>> getAllStacksOf(I object) {
        return this.inventory.getAllStacksOf(object);
    }

    @Override
    public void clear() {
        this.inventory.clear();
    }

    @Override
    public void sort(ItemComparator.SortMode sortmode, boolean ascending) {
        this.inventory.sort(sortmode, ascending);
    }

    public void updateValues() {
        this.inventory.updateValues();
    }

    @Override
    public float getWeight() {
        return this.inventory.getWeight();
    }

    @Override
    public float getValue() {
        return this.inventory.getValue();
    }

    @Override
    public float getItemCount() {
        return this.inventory.getItemCount();
    }

    @Override
    public int size() {
        return this.inventory.size();
    }

    public String toString() {
        return "Inventory{maxWeight=" + ((CargoSettings)this.settings).maxWeight + ", weight=" + this.getWeight() + ", value=" + this.getValue() + ", inventory=" + this.inventory + '}';
    }
}

