/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo;

import java.util.Objects;

public class Item<T> {
    private transient T object;
    private String icon;
    private String category;
    private String name;
    private float amount;
    public float basePrice;
    private float weight;

    public Item<T> copy() {
        Item<T> copy = new Item<T>();
        copy.object = this.object;
        copy.icon = this.icon;
        copy.category = this.category;
        copy.name = this.name;
        copy.amount = this.amount;
        copy.basePrice = this.basePrice;
        copy.weight = this.weight;
        return copy;
    }

    public Item<T> withName(String name) {
        this.name = name;
        return this;
    }

    public Item<T> withCategory(String category) {
        this.category = category;
        return this;
    }

    public Item<T> withObject(T object) {
        this.object = object;
        return this;
    }

    public Item<T> withIcon(String icon) {
        this.icon = icon;
        return this;
    }

    public Item<T> withWeight(float weight) {
        this.weight = weight;
        return this;
    }

    public Item<T> withAmount(float amount) {
        this.amount = amount;
        return this;
    }

    public Item<T> withBasePrice(float value) {
        this.basePrice = Math.abs(value);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public T getObject() {
        return this.object;
    }

    public void setObject(T object) {
        this.object = object;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public float getAmount() {
        return this.amount;
    }

    public void setAmount(float amount) {
        this.amount = amount;
    }

    public void addAmount(float amount) {
        this.amount += amount;
    }

    public void removeAmount(float amount) {
        this.amount -= Math.min(this.amount, amount);
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    public float getStackWeight() {
        return this.weight * this.amount;
    }

    public float getBasePrice() {
        return this.basePrice;
    }

    public float getStackValue() {
        return this.basePrice * this.amount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Item item = (Item)o;
        return this.object.equals(item.object);
    }

    public int hashCode() {
        return Objects.hash(this.object);
    }

    public String toString() {
        return "Item{name='" + this.name + '\'' + ", amount=" + this.amount + ", basePrice=" + this.basePrice + ", weight=" + this.weight + '}';
    }
}

