/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo;

import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.Item;
import java.util.Comparator;

public class ItemComparator
implements Comparator<Item<?>> {
    private SortMode sortMode = SortMode.NAME;
    private boolean ascending = true;

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    public SortMode getSortMode() {
        return this.sortMode;
    }

    public void setSortMode(SortMode sortMode) {
        this.sortMode = sortMode;
    }

    @Override
    public int compare(Item<?> o1, Item<?> o2) {
        return this.ascending ? this.sortMode.compare(o1, o2) : this.sortMode.compare(o1, o2) * -1;
    }

    public static enum SortMode {
        AMOUNT{

            @Override
            int compare(Item<?> item1, Item<?> item2) {
                if (item1 != null && item2 == null) {
                    return 1;
                }
                if (item1 == null && item2 != null) {
                    return -1;
                }
                if (item1.getAmount() > item2.getAmount()) {
                    return 1;
                }
                if (item1.getAmount() < item2.getAmount()) {
                    return -1;
                }
                return 0;
            }
        }
        ,
        NAME{

            @Override
            int compare(Item<?> item1, Item<?> item2) {
                if (item1 != null && item2 == null) {
                    return 1;
                }
                if (item1 == null && item2 != null) {
                    return -1;
                }
                if (item1.getName() != null && item2.getName() == null) {
                    return -1;
                }
                if (item1.getName() == null && item2.getName() != null) {
                    return 1;
                }
                return item1.getName().compareTo(item2.getName());
            }
        }
        ,
        WEIGHT{

            @Override
            int compare(Item<?> item1, Item<?> item2) {
                if (item1 != null && item2 == null) {
                    return 1;
                }
                if (item1 == null && item2 != null) {
                    return -1;
                }
                if (item1.getWeight() > item2.getWeight()) {
                    return 1;
                }
                if (item1.getWeight() < item2.getWeight()) {
                    return -1;
                }
                return 0;
            }
        }
        ,
        WEIGHT_STACK{

            @Override
            int compare(Item<?> item1, Item<?> item2) {
                if (item1 != null && item2 == null) {
                    return 1;
                }
                if (item1 == null && item2 != null) {
                    return -1;
                }
                if (item1.getStackWeight() > item2.getStackWeight()) {
                    return 1;
                }
                if (item1.getStackWeight() < item2.getStackWeight()) {
                    return -1;
                }
                return 0;
            }
        }
        ,
        VALUE{

            @Override
            int compare(Item<?> item1, Item<?> item2) {
                if (item1 != null && item2 == null) {
                    return 1;
                }
                if (item1 == null && item2 != null) {
                    return -1;
                }
                if (item1.basePrice > item2.basePrice) {
                    return 1;
                }
                if (item1.basePrice < item2.basePrice) {
                    return -1;
                }
                return 0;
            }
        }
        ,
        VALUE_STACK{

            @Override
            int compare(Item<?> item1, Item<?> item2) {
                if (item1 != null && item2 == null) {
                    return 1;
                }
                if (item1 == null && item2 != null) {
                    return -1;
                }
                if (item1.getStackValue() > item2.getStackValue()) {
                    return 1;
                }
                if (item1.getStackValue() < item2.getStackValue()) {
                    return -1;
                }
                return 0;
            }
        };


        abstract int compare(Item<?> var1, Item<?> var2);
    }
}

