/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo;

import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.Inventory;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.InventoryListener;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.Item;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.ItemComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class MultiStackInventory<I>
implements Inventory<I> {
    private boolean fireEvents = true;
    private String name;
    private transient float weight;
    private float maxWeight;
    private List<Item<I>> inventory = new ArrayList<Item<I>>();
    private transient ItemComparator comparator = new ItemComparator();
    private InventoryListener<I> listener;

    public MultiStackInventory(float maxWeight) {
        this.maxWeight = maxWeight;
    }

    public void setFireEvents(boolean fireEvents) {
        this.fireEvents = fireEvents;
    }

    @Override
    public InventoryListener<I> getListener() {
        return this.listener;
    }

    @Override
    public void setListener(InventoryListener<I> listener) {
        this.listener = listener;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public float getMaxWeight() {
        return this.maxWeight;
    }

    public List<Item<I>> getAllItems() {
        return this.inventory;
    }

    @Override
    public boolean canAdd(Item<I> item) {
        return this.weight + item.getStackWeight() <= this.maxWeight;
    }

    @Override
    public boolean canAddWeight(float weight) {
        return this.weight + weight <= this.maxWeight;
    }

    @Override
    public boolean canAddAmount(float amount) {
        return true;
    }

    public void addToStack(Item<I> item, float amount) {
        if (item == null) {
            return;
        }
        float weight = item.getWeight() * amount;
        if (this.canAddWeight(weight)) {
            Item<I> existingStack = this.getStackOf(item.getObject());
            existingStack.addAmount(amount);
            this.weight += amount * item.getWeight();
            if (this.listener != null && this.fireEvents) {
                this.listener.onStackChanged(existingStack);
            }
        }
    }

    public Item<I> get(int index) {
        return this.inventory.get(index);
    }

    @Override
    public float remove(Item<I> item) {
        if (item == null) {
            return 0.0f;
        }
        if (this.contains(item)) {
            Item<I> ownStack = this.getStackOf(item.getObject());
            float newAmount = ownStack.getAmount() - item.getAmount();
            if (newAmount <= 0.0f) {
                this.inventory.remove(ownStack);
                this.weight -= ownStack.getStackWeight();
                if (this.listener != null && this.fireEvents) {
                    this.listener.onStackRemoved(ownStack);
                }
                return Math.abs(newAmount);
            }
            ownStack.setAmount(newAmount);
            this.weight -= item.getStackWeight();
            if (this.listener != null && this.fireEvents) {
                this.listener.onStackChanged(ownStack);
            }
        }
        return 0.0f;
    }

    @Override
    public float remove(I object, float amount) {
        Item<I> existingStack = this.getStackOf(object);
        if (existingStack != null) {
            Item<I> newStack = new Item<I>();
            newStack.setObject(object);
            newStack.setName(existingStack.getName());
            newStack.setAmount(amount);
            newStack.withBasePrice(existingStack.basePrice);
            newStack.setWeight(existingStack.getWeight());
            return this.remove(newStack);
        }
        return amount;
    }

    @Override
    public void add(Item<I> item) {
        if (item == null) {
            return;
        }
        if (!this.contains(item)) {
            float stackweight = item.getStackWeight();
            if (this.canAddWeight(stackweight)) {
                this.inventory.add(item);
                this.weight += stackweight;
                if (this.listener != null && this.fireEvents) {
                    this.listener.onStackAdded(item);
                }
            }
        } else {
            this.addToStack(item, item.getAmount());
        }
    }

    @Override
    public float addWithRemainder(Item<I> item) {
        if (item == null) {
            return 0.0f;
        }
        float weightLeft = this.getMaxWeight() - this.getWeight();
        float allowedItems = Math.min(weightLeft / item.getWeight(), item.getAmount());
        if (allowedItems == 0.0f) {
            return item.getAmount();
        }
        if (!this.contains(item)) {
            Item<I> copy = item.copy();
            copy.setAmount(allowedItems);
            this.inventory.add(copy);
            this.weight += copy.getStackWeight();
            if (this.listener != null && this.fireEvents) {
                this.listener.onStackAdded(copy);
            }
        } else {
            Item<I> existingStack = this.getStackOf(item.getObject());
            this.addToStack(existingStack, allowedItems);
        }
        return item.getAmount() - allowedItems;
    }

    @Override
    public boolean contains(Item<?> otherItem) {
        return this.contains(otherItem.getObject());
    }

    @Override
    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        for (Item<I> item : this.inventory) {
            if (!Objects.equals(item.getObject(), object)) continue;
            return true;
        }
        return false;
    }

    public Item<I> getStackOf(I object) {
        for (Item<I> item : this.inventory) {
            if (!Objects.equals(item.getObject(), object)) continue;
            return item;
        }
        return null;
    }

    public List<Item<I>> getAllStacksOf(I object) {
        ArrayList<Item<I>> stacks = new ArrayList<Item<I>>();
        for (Item<I> item : this.inventory) {
            if (!Objects.equals(item.getObject(), object)) continue;
            stacks.add(item);
        }
        return stacks;
    }

    @Override
    public void clear() {
        this.inventory.clear();
        this.updateValues();
    }

    @Override
    public void sort(ItemComparator.SortMode sortmode, boolean ascending) {
        this.comparator.setSortMode(sortmode);
        this.comparator.setAscending(ascending);
        Collections.sort(this.inventory, this.comparator);
    }

    public void updateValues() {
        this.weight = 0.0f;
        for (Item<I> item : this.inventory) {
            this.weight += item.getStackWeight();
        }
    }

    @Override
    public float getWeight() {
        return this.weight;
    }

    @Override
    public float getValue() {
        float tradeValue = 0.0f;
        for (Item<I> item : this.inventory) {
            tradeValue += item.getStackValue();
        }
        return tradeValue;
    }

    @Override
    public float getItemCount() {
        float itemCount = 0.0f;
        for (Item<I> item : this.inventory) {
            itemCount += item.getAmount();
        }
        return itemCount;
    }

    public MultiStackInventory<I> copy() {
        MultiStackInventory<I> copy = new MultiStackInventory<I>(this.maxWeight);
        for (Item<I> item : this.inventory) {
            copy.add(item.copy());
        }
        return copy;
    }

    @Override
    public int size() {
        return this.inventory.size();
    }

    public String toString() {
        return "MultiStackInventory{name=" + this.name + ", maxWeight=" + this.maxWeight + ", value=" + this.getValue() + ", inventory=" + this.inventory + '}';
    }
}

