/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo;

import com.badlogic.gdx.math.MathUtils;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.BulkInventory;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.InventoryListener;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.Item;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.ItemComparator;
import java.util.Objects;

public class SingleStackInventory<I>
implements BulkInventory<I> {
    private String name;
    private Item<I> item;
    private float maxAmount;
    private InventoryListener<I> listener;

    protected SingleStackInventory() {
        this.item = new Item();
    }

    public SingleStackInventory(float maxAmount) {
        this.maxAmount = maxAmount;
        this.item = new Item();
    }

    public SingleStackInventory(float maxAmount, Item<I> item) {
        this.maxAmount = maxAmount;
        this.item = item;
        this.item.setAmount(MathUtils.clamp(this.item.getAmount(), 0.0f, this.maxAmount));
    }

    @Override
    public void addUntilFull(float amount) {
        this.item.setAmount(Math.min(this.item.getAmount() + amount, this.maxAmount));
    }

    @Override
    public void removeUntilEmpty(float amount) {
        this.item.setAmount(Math.max(0.0f, this.item.getAmount() - amount));
    }

    @Override
    public void setItem(Item<I> item) {
        if (this.item.getAmount() == 0.0f) {
            this.item = item;
        }
    }

    @Override
    public Item<I> getItem() {
        return this.item.copy();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public float getMaxWeight() {
        return this.maxAmount * this.item.getWeight();
    }

    @Override
    public boolean canAdd(Item<I> item) {
        return this.item.getAmount() + item.getAmount() <= this.maxAmount;
    }

    @Override
    public boolean canAddWeight(float weight) {
        return true;
    }

    @Override
    public boolean canAddAmount(float amount) {
        return this.item.getAmount() + amount <= this.maxAmount;
    }

    @Override
    public float remove(Item<I> item) {
        if (!Objects.equals(this.item.getObject(), item.getObject())) {
            return 0.0f;
        }
        float newAmount = this.item.getAmount() - item.getAmount();
        this.item.setAmount(Math.max(0.0f, newAmount));
        return newAmount < 0.0f ? Math.abs(newAmount) : 0.0f;
    }

    @Override
    public float remove(I object, float amount) {
        if (!Objects.equals(this.item.getObject(), object)) {
            return 0.0f;
        }
        float newAmount = this.item.getAmount() - amount;
        this.item.setAmount(Math.max(0.0f, newAmount));
        return newAmount < 0.0f ? Math.abs(newAmount) : 0.0f;
    }

    @Override
    public void add(Item<I> item) {
        if (!Objects.equals(this.item.getObject(), item.getObject())) {
            return;
        }
        if (this.canAddAmount(item.getAmount())) {
            this.item.setAmount(this.item.getAmount() + item.getAmount());
        }
    }

    @Override
    public float addWithRemainder(Item<I> item) {
        if (!Objects.equals(this.item.getObject(), item.getObject())) {
            return 0.0f;
        }
        float remainingAmount = 0.0f;
        float newAmount = this.item.getAmount() + item.getAmount();
        if (newAmount >= this.maxAmount) {
            remainingAmount = newAmount - this.maxAmount;
        }
        this.item.setAmount(Math.min(this.maxAmount, newAmount));
        return remainingAmount;
    }

    @Override
    public boolean contains(Item<?> otherItem) {
        if (this.item.getAmount() <= 0.0f) {
            return false;
        }
        return Objects.equals(this.item, otherItem);
    }

    @Override
    public boolean contains(Object object) {
        if (this.item.getAmount() <= 0.0f) {
            return false;
        }
        return Objects.equals(this.item.getObject(), object);
    }

    @Override
    public void clear() {
        this.item.setAmount(0.0f);
    }

    @Override
    public void sort(ItemComparator.SortMode sortmode, boolean ascending) {
    }

    @Override
    public float getWeight() {
        return this.item.getStackWeight();
    }

    @Override
    public float getValue() {
        return this.item.getStackValue();
    }

    @Override
    public float getItemCount() {
        return this.item.getAmount();
    }

    @Override
    public int size() {
        if (this.item.getAmount() <= 0.0f) {
            return 0;
        }
        return 1;
    }

    @Override
    public InventoryListener<I> getListener() {
        return this.listener;
    }

    @Override
    public void setListener(InventoryListener<I> listener) {
        this.listener = listener;
    }

    public String toString() {
        return "SingleStackInventory{name=" + this.name + ", contents=" + this.getItemCount() + "/" + this.maxAmount + '}';
    }
}

