/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.docking;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.ParallelAction;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.Message;
import com.neutronio.astrax.app.datapack.DataPack;
import com.neutronio.astrax.app.datapack.game.GameLogic;
import com.neutronio.astrax.app.datapack.game.world.SatelliteTarget;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.docking.Docker;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.docking.DockingSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.propulsion.PropulsionSystem;
import com.neutronio.astrax.gfx.SatelliteGraphics;
import com.neutronio.astrax.gfx.StarSystemGraphics;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.util.AstraXUtil;
import com.neutronio.astrax.util.MathUtil;
import com.neutronio.astrax.util.Vector2i;

public class Docking
extends GameLogic {
    private ComponentFactory componentFactory = AstraXApp.astraX.getAppFactoryByClass(ComponentFactory.class);
    private static float defaultDockingTime = 4.0f;
    private static float defaultUndockingTime = 2.0f;

    public Docking(DataPack dataPack) {
        super(dataPack);
    }

    public boolean inRange(SatelliteTarget primary, SatelliteTarget secondary) {
        Vector2 primaryLoc = new Vector2();
        AstraXUtil.getWorldPosition(primaryLoc, primary.getGraphics());
        Vector2 secondaryLoc = new Vector2(((SatelliteGraphics)secondary.getGraphics()).getX(), ((SatelliteGraphics)secondary.getGraphics()).getY());
        float distance = primaryLoc.dst(secondaryLoc);
        return distance < 300.0f;
    }

    public Message dock(SatelliteTarget primary, SatelliteTarget secondary) {
        Message message = new Message();
        Group primaryGraphics = (Group)primary.getGraphics();
        DockingSystem primaryDockingSystem = ((Satellite)primary.getModel()).getSystem(DockingSystem.class);
        DockingSystem secondaryDockingSystem = ((Satellite)secondary.getModel()).getSystem(DockingSystem.class);
        Group secondaryGraphics = (Group)secondary.getGraphics();
        Docker primaryDockingPoint = primaryDockingSystem.findDocker(((Satellite)secondary.getModel()).getSatelliteGrid().vesselSize);
        Docker secondaryDockingPoint = secondaryDockingSystem.findDocker(((Satellite)secondary.getModel()).getSatelliteGrid().vesselSize);
        if (primaryDockingPoint == null || secondaryDockingPoint == null) {
            message.setMessage(this.componentFactory.translate("game_message_dock_no_suitable_dock"));
            message.setType(Message.MessageType.WARNING);
            return message;
        }
        boolean dockingInitiated = ((Satellite)secondary.getModel()).getSystem(DockingSystem.class).inititateDocking(defaultDockingTime, primary);
        if (!dockingInitiated) {
            message.setMessage(this.componentFactory.translate("game_message_dock_could_not_initiate"));
            message.setType(Message.MessageType.WARNING);
            return message;
        }
        primaryDockingPoint.setDockedVessel((Satellite)secondary.getModel());
        primaryDockingPoint.setDockedPoint(secondaryDockingPoint);
        secondaryDockingPoint.setDockedVessel((Satellite)primary.getModel());
        secondaryDockingPoint.setDockedPoint(primaryDockingPoint);
        ((Satellite)secondary.getModel()).getSystem(PropulsionSystem.class).stop();
        secondaryGraphics.clearActions();
        Vector2 posInsideStation = primaryGraphics.stageToLocalCoordinates(new Vector2(secondaryGraphics.getX(), secondaryGraphics.getY()));
        primaryGraphics.addActor(secondaryGraphics);
        secondaryGraphics.setPosition(posInsideStation.x, posInsideStation.y);
        Actor primDockerGraphics = ((SatelliteGraphics)primary.getGraphics()).getGraphicsAtGridLocation(primaryDockingPoint.getLocation().x, primaryDockingPoint.getLocation().y);
        Actor secDockerGraphics = ((SatelliteGraphics)secondary.getGraphics()).getGraphicsAtGridLocation(secondaryDockingPoint.getLocation().x, secondaryDockingPoint.getLocation().y);
        Vector2i dockingPos = new Vector2i((int)(primDockerGraphics.getX() - secDockerGraphics.getX()), (int)(primDockerGraphics.getY() - secDockerGraphics.getY()));
        ParallelAction dockingAction = new ParallelAction(Actions.moveTo(dockingPos.x, dockingPos.y, defaultDockingTime), Actions.rotateTo(primaryDockingPoint.getAngle(), defaultDockingTime / 2.0f));
        ((SatelliteGraphics)secondary.getGraphics()).addAction(dockingAction);
        message.setMessage(this.componentFactory.translate("game_message_dock_initiated"));
        message.setType(Message.MessageType.SUCCESS);
        AstraXApp.astraX.getSfxSoundManager().playSoundOnce("docking");
        return message;
    }

    public void forceDock(SatelliteTarget primary, SatelliteTarget secondary) {
        Group primaryGraphics = (Group)primary.getGraphics();
        DockingSystem primaryDockingSystem = ((Satellite)primary.getModel()).getSystem(DockingSystem.class);
        DockingSystem secondaryDockingSystem = ((Satellite)secondary.getModel()).getSystem(DockingSystem.class);
        Group secondaryGraphics = (Group)secondary.getGraphics();
        Docker primaryDockingPoint = primaryDockingSystem.findDocker(((Satellite)secondary.getModel()).getSatelliteGrid().vesselSize);
        Docker secondaryDockingPoint = secondaryDockingSystem.findDocker(((Satellite)secondary.getModel()).getSatelliteGrid().vesselSize);
        primaryDockingPoint.setDockedVessel((Satellite)secondary.getModel());
        primaryDockingPoint.setDockedPoint(secondaryDockingPoint);
        secondaryDockingPoint.setDockedVessel((Satellite)primary.getModel());
        secondaryDockingPoint.setDockedPoint(primaryDockingPoint);
        ((Satellite)secondary.getModel()).getSystem(PropulsionSystem.class).stop();
        secondaryGraphics.clearActions();
        Vector2 posInsideStation = primaryGraphics.stageToLocalCoordinates(new Vector2(secondaryGraphics.getX(), secondaryGraphics.getY()));
        primaryGraphics.addActor(secondaryGraphics);
        secondaryGraphics.setPosition(posInsideStation.x, posInsideStation.y);
        Actor primDockerGraphics = ((SatelliteGraphics)primary.getGraphics()).getGraphicsAtGridLocation(primaryDockingPoint.getLocation().x, primaryDockingPoint.getLocation().y);
        Actor secDockerGraphics = ((SatelliteGraphics)secondary.getGraphics()).getGraphicsAtGridLocation(secondaryDockingPoint.getLocation().x, secondaryDockingPoint.getLocation().y);
        Vector2i dockingPos = new Vector2i((int)(primDockerGraphics.getX() - secDockerGraphics.getX()), (int)(primDockerGraphics.getY() - secDockerGraphics.getY()));
        ParallelAction dockingAction = new ParallelAction(Actions.moveTo(dockingPos.x, dockingPos.y), Actions.rotateTo(primaryDockingPoint.getAngle()));
        ((SatelliteGraphics)secondary.getGraphics()).addAction(dockingAction);
    }

    public Message undock(Stage root, SatelliteTarget primary, SatelliteTarget secondary) {
        AstraXApp.astraX.getSfxSoundManager().playSoundOnce("undocking", 1.1f);
        Message message = new Message();
        boolean undockingInitiated = ((Satellite)secondary.getModel()).getSystem(DockingSystem.class).inititateUndocking(defaultUndockingTime, primary);
        if (!undockingInitiated) {
            message.setMessage(this.componentFactory.translate("game_message_undock_could_not_initiate"));
            message.setType(Message.MessageType.WARNING);
            return message;
        }
        DockingSystem primaryDockingSystem = ((Satellite)primary.getModel()).getSystem(DockingSystem.class);
        Docker primDocker = primaryDockingSystem.getDockerOfDockedVessel((Satellite)secondary.getModel());
        primDocker.setDockedVessel(null);
        primDocker.setDockedPoint(null);
        DockingSystem secondaryDockingSystem = ((Satellite)secondary.getModel()).getSystem(DockingSystem.class);
        Docker secDocker = secondaryDockingSystem.getDockerOfDockedVessel((Satellite)primary.getModel());
        secDocker.setDockedVessel(null);
        secDocker.setDockedPoint(null);
        ((Satellite)secondary.getModel()).getSystem(PropulsionSystem.class).start();
        Actor primDockerImage = ((SatelliteGraphics)primary.getGraphics()).getGraphicsAtGridLocation(primDocker.getLocation().x, primDocker.getLocation().y);
        Vector2 sectorPosition = new Vector2(primDockerImage.getX(), primDockerImage.getY());
        Docking.getSectorPosition(sectorPosition, primary.getGraphics());
        Vector2 globalPosition = this.getParentWorld().sectorToGlobalCoordinates(sectorPosition.x, sectorPosition.y);
        root.addActor((Actor)secondary.getGraphics());
        this.getParentWorld().teleportToPosition(secondary, globalPosition.x, globalPosition.y);
        Vector2 directionalVector = MathUtil.getDirectionalVector(200.0f, primDocker.getAngle() + 90.0f);
        ParallelAction undockingAction = new ParallelAction(Actions.moveBy(directionalVector.x, directionalVector.y, defaultUndockingTime));
        ((SatelliteGraphics)secondary.getGraphics()).addAction(undockingAction);
        message.setMessage(this.componentFactory.translate("game_message_undock_initiated"));
        message.setType(Message.MessageType.SUCCESS);
        return message;
    }

    private static void getSectorPosition(Vector2 store, Actor actor) {
        Actor current = actor;
        do {
            store.x += current.getX();
            store.y += current.getY();
        } while ((current = current.getParent()) != null && !(current instanceof StarSystemGraphics));
    }
}

