/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.docking;

import com.neutronio.astrax.app.datapack.game.world.SatelliteTarget;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.FunctionalSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.docking.Docker;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.docking.DockingState;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.docking.VesselSize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DockingSystem
extends FunctionalSystem<Satellite> {
    private List<Docker> dockerModules = new ArrayList<Docker>();
    private DockingState dockingState = DockingState.UNDOCKED;
    private float dockingTimer = 4.0f;
    private SatelliteTarget dockedStationTarget = null;
    private List<DockingSystemListener> listeners = new ArrayList<DockingSystemListener>();

    public DockingSystem(String displayName, Satellite parent) {
        super(displayName, parent);
    }

    public void addDocker(Docker dockerModule) {
        this.dockerModules.add(dockerModule);
    }

    public Docker getDockerOfDockedVessel(Satellite satellite) {
        for (Docker dockerModule : this.dockerModules) {
            if (!Objects.equals(dockerModule.getDockedVessel(), satellite)) continue;
            return dockerModule;
        }
        return null;
    }

    public Docker findDocker(VesselSize vesselSize) {
        for (Docker dockerModule : this.dockerModules) {
            if (dockerModule.getDockedVessel() != null) continue;
            for (VesselSize dockingSize : dockerModule.getSuitedFor()) {
                if (!vesselSize.fitsInto(dockingSize)) continue;
                return dockerModule;
            }
        }
        return null;
    }

    public boolean hasFreeDockingPointFor(Satellite satellite) {
        boolean hasPoint = false;
        for (Docker docker : this.dockerModules) {
            if (docker.getDockedVessel() != null) continue;
            for (VesselSize size : docker.getSuitedFor()) {
                if (!Objects.equals((Object)size, (Object)satellite.getSatelliteGrid().vesselSize)) continue;
                hasPoint = true;
            }
        }
        return hasPoint;
    }

    public DockingState getDockingState() {
        return this.dockingState;
    }

    public void addListener(DockingSystemListener spaceShipListener) {
        if (spaceShipListener == null) {
            return;
        }
        this.listeners.add(spaceShipListener);
    }

    public void removeListener(DockingSystemListener spaceShipListener) {
        if (spaceShipListener == null) {
            return;
        }
        this.listeners.remove(spaceShipListener);
    }

    private void fireOnDocked() {
        for (DockingSystemListener listener : this.listeners) {
            listener.onDocked((Satellite)this.getParent(), (Satellite)this.dockedStationTarget.getModel());
        }
    }

    private void fireOnUndocked() {
        for (DockingSystemListener listener : this.listeners) {
            listener.onUndocked((Satellite)this.getParent(), (Satellite)this.dockedStationTarget.getModel());
        }
    }

    public boolean inititateDocking(float dockingTime, SatelliteTarget station) {
        if (this.dockingState == DockingState.UNDOCKED) {
            this.dockingState = DockingState.DOCKING;
            this.dockingTimer = dockingTime;
            this.dockedStationTarget = station;
            return true;
        }
        return false;
    }

    public boolean inititateUndocking(float undockingTime, SatelliteTarget station) {
        if (this.dockingState == DockingState.DOCKED) {
            this.dockingState = DockingState.UNDOCKING;
            this.dockingTimer = undockingTime;
            this.dockedStationTarget = station;
            return true;
        }
        return false;
    }

    public SatelliteTarget getDockedStationTarget() {
        return this.dockedStationTarget;
    }

    @Override
    public void update(float delta) {
        if (this.dockingState == DockingState.DOCKING) {
            this.dockingTimer -= delta;
            if (this.dockingTimer < 0.0f) {
                this.dockingState = DockingState.DOCKED;
                this.fireOnDocked();
            }
        }
        if (this.dockingState == DockingState.UNDOCKING) {
            this.dockingTimer -= delta;
            if (this.dockingTimer < 0.0f) {
                this.dockingState = DockingState.UNDOCKED;
                this.fireOnUndocked();
                this.dockedStationTarget = null;
            }
        }
    }

    public static interface DockingSystemListener {
        public void onDocked(Satellite var1, Satellite var2);

        public void onUndocked(Satellite var1, Satellite var2);
    }
}

