/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.mining;

import com.neutronio.astrax.app.datapack.EntityID;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SavedModuleFunction;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.ModuleFunction;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.mining.DrillSettings;

public class MiningDrill
extends ModuleFunction<DrillSettings> {
    private float hitpoints;
    private float gatheringInterval = 4.0f;
    private float gatheringYield = 10.0f;
    private float miningTimer = this.gatheringInterval;

    public MiningDrill(SavedModuleFunction moduleFunction) {
        this.miningTimer = moduleFunction.drillMiningTimer;
    }

    public MiningDrill() {
        super(null, null);
    }

    public MiningDrill(EntityID id, DrillSettings functionality) {
        super(id, functionality);
    }

    @Override
    public String getUsedResourceID() {
        return ((DrillSettings)this.settings).fuelType;
    }

    public float getGatheringInterval() {
        return this.gatheringInterval;
    }

    public void setGatheringInterval(float gatheringInterval) {
        this.miningTimer = this.gatheringInterval = gatheringInterval;
    }

    public float getGatheringYield() {
        return this.gatheringYield;
    }

    public void setGatheringYield(float gatheringYield) {
        this.gatheringYield = gatheringYield;
    }

    public float getHitpoints() {
        return this.hitpoints;
    }

    public void setHitpoints(float hitpoints) {
        this.hitpoints = hitpoints;
    }

    public float getMiningTimer() {
        return this.miningTimer;
    }

    public void setMiningTimer(float miningTimer) {
        this.miningTimer = miningTimer;
    }

    public float getMiningProgress() {
        return this.miningTimer / this.gatheringInterval;
    }

    public boolean mine(float delta) {
        this.miningTimer -= 1.0f * delta;
        if (this.miningTimer <= 0.0f) {
            this.miningTimer = this.gatheringInterval;
            return true;
        }
        return false;
    }

    public void resetMining() {
        this.miningTimer = this.gatheringInterval;
    }
}

