/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.mining;

import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.FunctionalSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.Module;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.mining.MiningDrill;
import java.util.ArrayList;
import java.util.List;

public class MiningSystem
extends FunctionalSystem<Satellite> {
    private List<Module> miningDrills = new ArrayList<Module>();
    private MiningSystemListener miningListener;

    public MiningSystem(String displayName, Satellite parent) {
        super(displayName, parent);
    }

    public void setMiningListener(MiningSystemListener miningListener) {
        this.miningListener = miningListener;
    }

    public List<Module> getMiningDrills() {
        return this.miningDrills;
    }

    public void addMiningDrill(Module miningDrill) {
        if (miningDrill == null) {
            return;
        }
        this.miningDrills.add(miningDrill);
    }

    public void startMiningDrills() {
        for (Module drillModule : this.miningDrills) {
            drillModule.startModule();
            this.miningListener.onDrillStart(drillModule);
        }
    }

    public void stopMiningDrills() {
        for (Module drillModule : this.miningDrills) {
            drillModule.stopModule();
            this.miningListener.onDrillStop(drillModule);
        }
    }

    public void toggleMiningDrills() {
        for (Module drillModule : this.miningDrills) {
            if (drillModule.isRunning()) {
                drillModule.stopModule();
                this.miningListener.onDrillStop(drillModule);
                continue;
            }
            drillModule.startModule();
            this.miningListener.onDrillStart(drillModule);
        }
    }

    @Override
    public void update(float delta) {
        for (Module drillModule : this.miningDrills) {
            MiningDrill miningDrill = drillModule.getFunctionality(MiningDrill.class);
            if (!drillModule.isRunning() || miningDrill == null || !miningDrill.mine(delta) || this.miningListener == null) continue;
            this.miningListener.onResourceMined(drillModule, miningDrill.getGatheringYield());
        }
    }

    public static interface MiningSystemListener {
        public void onResourceMined(Module var1, float var2);

        public void onDrillStart(Module var1);

        public void onDrillStop(Module var1);
    }
}

