/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.propulsion;

import com.badlogic.gdx.math.Vector2;
import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.FunctionalSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.Module;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.propulsion.Thruster;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.propulsion.ThrusterSettings;
import com.neutronio.astrax.util.MathUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PropulsionSystem
extends FunctionalSystem<Satellite> {
    public static final String CONTROL_LATERAL = "FLAT";
    public static final String CONTROL_LATERAL_NEGATIVE = "NLAT";
    public static final String CONTROL_WEST = "RWES";
    public static final String CONTROL_EAST = "REAS";
    private Vector2 travelDirection = new Vector2();
    private float rotationalForce = 0.0f;
    protected ThrusterControlGroup thrusterControlGroup = new ThrusterControlGroup();
    private PropulsionSystemListener listener;

    public PropulsionSystem(String displayName, Satellite parent) {
        super(displayName, parent);
    }

    public void setListener(PropulsionSystemListener listener) {
        this.listener = listener;
    }

    public Vector2 getTravelDirection() {
        return this.travelDirection;
    }

    public float getRotationalForce() {
        return this.rotationalForce;
    }

    public void addToControlGroup(String name, Module module) {
        ThrusterController thrusterController = null;
        Thruster thruster = module.getFunctionality(Thruster.class);
        if (thruster == null) {
            return;
        }
        if (!this.thrusterControlGroup.groups.containsKey(name)) {
            thrusterController = new ThrusterController();
            this.thrusterControlGroup.addGroup(name, thrusterController);
        } else {
            thrusterController = this.thrusterControlGroup.groups.get(name);
        }
        if (thrusterController == null) {
            throw new AstraXException(AstraXException.ErrorCode.E3000, name);
        }
        thrusterController.addThruster(thruster);
    }

    public ThrusterController getThrusterController(String ofGroup) {
        return this.thrusterControlGroup.getThrusterController(ofGroup);
    }

    public boolean hasThrusterController(String group) {
        return this.thrusterControlGroup.groups.containsKey(group);
    }

    public ThrusterControlGroup getThrusterControlGroup() {
        return this.thrusterControlGroup;
    }

    public void throttleIncrease(float delta) {
        if (((Satellite)this.getParent()).isDocked()) {
            return;
        }
        this.thrusterControlGroup.throttleIncrease(CONTROL_LATERAL, delta);
    }

    public void throttleIncrease(float delta, String thrusterGroup) {
        if (((Satellite)this.getParent()).isDocked()) {
            return;
        }
        this.thrusterControlGroup.throttleIncrease(thrusterGroup, delta);
    }

    public void throttleDecrease(float delta) {
        if (((Satellite)this.getParent()).isDocked()) {
            return;
        }
        this.thrusterControlGroup.throttleDecrease(CONTROL_LATERAL, delta);
    }

    public void throttleDecrease(float delta, String thrusterGroup) {
        if (((Satellite)this.getParent()).isDocked()) {
            return;
        }
        this.thrusterControlGroup.throttleDecrease(thrusterGroup, delta);
    }

    public void rotate(float direction, float delta, float strength) {
        if (((Satellite)this.getParent()).isDocked()) {
            return;
        }
        if (direction > 0.0f) {
            this.thrusterControlGroup.hold(CONTROL_WEST, delta * 10.0f);
        } else {
            this.thrusterControlGroup.hold(CONTROL_EAST, delta * 10.0f);
        }
    }

    public void brakeRotation(float delta) {
        if (((Satellite)this.getParent()).isDocked()) {
            return;
        }
        this.thrusterControlGroup.throttleDecrease(CONTROL_EAST, delta * 10.0f);
        this.thrusterControlGroup.throttleDecrease(CONTROL_WEST, delta * 10.0f);
    }

    @Override
    public void update(float delta) {
        this.thrusterControlGroup.update(delta);
        this.travelDirection.set(0.0f, 0.0f);
        float thrust = this.thrusterControlGroup.getThrusterController((String)CONTROL_LATERAL).thrust;
        float direction = this.thrusterControlGroup.getThrusterController(CONTROL_LATERAL).direction;
        if (this.thrusterControlGroup.getThrusterController(CONTROL_LATERAL_NEGATIVE) != null) {
            thrust -= this.thrusterControlGroup.getThrusterController((String)CONTROL_LATERAL_NEGATIVE).thrust;
            direction -= this.thrusterControlGroup.getThrusterController(CONTROL_LATERAL_NEGATIVE).direction;
        }
        this.travelDirection.set(MathUtil.getDirectionalVector(thrust * 1000.0f * delta, direction / (float)this.thrusterControlGroup.groups.size()));
        if (this.thrusterControlGroup.getThrusterController(CONTROL_WEST) != null && this.thrusterControlGroup.getThrusterController(CONTROL_EAST) != null) {
            this.rotationalForce = this.thrusterControlGroup.getThrusterController((String)CONTROL_WEST).thrust - this.thrusterControlGroup.getThrusterController((String)CONTROL_EAST).thrust;
        }
    }

    public void start() {
        if (((Satellite)this.getParent()).isDocked()) {
            return;
        }
        this.thrusterControlGroup.startAllThrusters();
    }

    public void start(String group) {
        if (((Satellite)this.getParent()).isDocked()) {
            return;
        }
        this.thrusterControlGroup.startThrusters(group);
    }

    public void stop() {
        this.thrusterControlGroup.stopAllThrusters();
    }

    public void stop(String group) {
        this.thrusterControlGroup.stopThrusters(group);
    }

    public static interface PropulsionSystemListener {
        public void onThrusterGroupStarted(Satellite var1, List<Thruster> var2);

        public void onThrusterGroupStopped(Satellite var1, List<Thruster> var2);
    }

    public static class ThrusterControlGroup {
        Map<String, ThrusterController> groups = new HashMap<String, ThrusterController>();

        public ThrusterController getThrusterController(String name) {
            return this.groups.get(name);
        }

        public Thruster getElement(String name, int index) {
            ThrusterController controller = this.groups.get(name);
            if (controller != null) {
                return controller.thrusters.get(index);
            }
            return null;
        }

        public void addGroup(String name, ThrusterController thrusterController) {
            if (thrusterController != null) {
                this.groups.put(name, thrusterController);
            }
        }

        public void stopAllThrusters() {
            Set<String> groupKeys = this.groups.keySet();
            for (String key : groupKeys) {
                this.stopThrusters(key);
            }
        }

        public void stopThrusters(String group) {
            ThrusterController controller = this.groups.get(group);
            if (controller != null) {
                controller.stop();
            }
        }

        public void startAllThrusters() {
            Set<String> groupKeys = this.groups.keySet();
            for (String key : groupKeys) {
                this.startThrusters(key);
            }
        }

        public void startThrusters(String group) {
            ThrusterController controller = this.groups.get(group);
            if (controller != null) {
                controller.start();
            }
        }

        public void throttleIncrease(String group, float delta) {
            ThrusterController controller = this.groups.get(group);
            if (controller != null) {
                controller.throttleIncrease(delta);
            }
        }

        public void throttleDecrease(String group, float delta) {
            ThrusterController controller = this.groups.get(group);
            if (controller != null) {
                controller.throttleDecrease(delta);
            }
        }

        public void hold(String group, float delta) {
            ThrusterController controller = this.groups.get(group);
            if (controller != null) {
                controller.hold(delta);
            }
        }

        public synchronized void update(float delta) {
            for (ThrusterController controller : this.groups.values()) {
                controller.thrust = 0.0f;
                for (Thruster thruster : controller.thrusters) {
                    controller.thrust += thruster.getCurrentThrust();
                }
                controller.thrust /= controller.maxThrust;
            }
        }
    }

    public class ThrusterController {
        protected List<Thruster> thrusters = new ArrayList<Thruster>();
        protected float thrust;
        protected float maxThrust;
        protected boolean running;
        private float direction = 0.0f;

        public float getDirection() {
            return this.direction;
        }

        public float getThrust() {
            return this.thrust;
        }

        public void addThruster(Thruster thruster) {
            if (thruster != null) {
                thruster.setRunning(this.running);
                this.maxThrust += ((ThrusterSettings)thruster.getSettings()).maxThrust;
                this.thrusters.add(thruster);
                this.direction += thruster.getAngle() % 360.0f;
            }
        }

        public void toggle() {
            if (this.running) {
                this.stop();
            } else {
                this.start();
            }
        }

        public void start() {
            this.running = true;
            for (Thruster thruster : this.thrusters) {
                thruster.setRunning(this.running);
            }
            if (PropulsionSystem.this.listener != null) {
                PropulsionSystem.this.listener.onThrusterGroupStarted((Satellite)PropulsionSystem.this.getParent(), this.thrusters);
            }
        }

        public void stop() {
            this.thrust = 0.0f;
            this.running = false;
            for (Thruster thruster : this.thrusters) {
                thruster.setRunning(this.running);
            }
            if (PropulsionSystem.this.listener != null) {
                PropulsionSystem.this.listener.onThrusterGroupStopped((Satellite)PropulsionSystem.this.getParent(), this.thrusters);
            }
        }

        public synchronized void throttleIncrease(float delta) {
            for (Thruster thruster : this.thrusters) {
                thruster.increaseThrust(delta);
            }
        }

        public synchronized void throttleDecrease(float delta) {
            for (Thruster thruster : this.thrusters) {
                thruster.decreaseThrust(delta);
            }
        }

        public synchronized void hold(float delta) {
            for (Thruster thruster : this.thrusters) {
                thruster.hold(delta);
            }
        }
    }
}

