/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.propulsion;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.datapack.EntityID;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SavedModuleFunction;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.ModuleFunction;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.propulsion.ThrusterSettings;
import java.util.Objects;

public class Thruster
extends ModuleFunction<ThrusterSettings> {
    protected static float threshold = 0.001f;
    protected float currentThrust = 0.0f;
    protected float targetThrust = 0.0f;
    protected boolean running = false;
    public float angle = 0.0f;

    public Thruster() {
    }

    public Thruster(SavedModuleFunction moduleFunction) {
        this.currentThrust = moduleFunction.thrusterCurrentThrust;
        this.targetThrust = moduleFunction.thrusterTargetThrust;
        this.running = moduleFunction.thrusterRunning;
        this.settings = (ThrusterSettings)moduleFunction.settings;
    }

    public Thruster(EntityID id, ThrusterSettings functionality) {
        super(id, functionality);
        if (((ThrusterSettings)this.settings).maxThrust == 0.0f || ((ThrusterSettings)this.settings).deltaThrust == 0.0f) {
            throw new AstraXException(AstraXException.ErrorCode.E0001, "Delta/Max Thrust cannot be 0!");
        }
    }

    public float getAngle() {
        return this.parent.getOrientation().getRotationDegrees();
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }

    public float getTargetThrust() {
        return this.targetThrust;
    }

    @Override
    public String getUsedResourceID() {
        return ((ThrusterSettings)this.settings).fuelType;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
        if (!this.running) {
            this.targetThrust = 0.0f;
        }
    }

    public void resetCurrentThrust() {
        this.targetThrust = 0.0f;
    }

    public float getCurrentThrust() {
        if (this.isRunning()) {
            return this.currentThrust;
        }
        return 0.0f;
    }

    public float getThrusterPowerFactor() {
        return this.currentThrust / ((ThrusterSettings)this.settings).maxThrust;
    }

    public void increaseThrust(float delta) {
        if (Objects.equals((Object)((ThrusterSettings)this.settings).operationMode, (Object)ThrusterSettings.OperationMode.THROTTLE)) {
            this.targetThrust = Math.min(((ThrusterSettings)this.settings).maxThrust, this.targetThrust + ((ThrusterSettings)this.settings).deltaThrust * delta);
        }
    }

    public void decreaseThrust(float delta) {
        if (Objects.equals((Object)((ThrusterSettings)this.settings).operationMode, (Object)ThrusterSettings.OperationMode.THROTTLE) && this.targetThrust > 0.0f) {
            float strength = MathUtils.clamp(0.99f - delta, 0.1f, 1.0f);
            this.targetThrust = MathUtils.clamp(this.targetThrust * strength, 0.0f, ((ThrusterSettings)this.settings).maxThrust);
            if (this.targetThrust < threshold) {
                this.currentThrust = 0.0f;
            }
        }
    }

    public void hold(float delta) {
        if (Objects.equals((Object)((ThrusterSettings)this.settings).operationMode, (Object)ThrusterSettings.OperationMode.HOLD)) {
            this.targetThrust = ((ThrusterSettings)this.settings).maxThrust;
        }
    }

    public void brake(float delta) {
        float strength = MathUtils.clamp(0.9f - delta, 0.1f, 0.95f);
        this.targetThrust *= strength;
        if (Math.abs(this.currentThrust) < threshold) {
            this.currentThrust = 0.0f;
        }
    }

    public float getFuelConsumption(float thrusterPower) {
        if (this.parent.isRunning()) {
            return thrusterPower * ((ThrusterSettings)this.settings).fuelConsumption + ((ThrusterSettings)this.settings).fuelIdleConsumption;
        }
        return 0.0f;
    }

    @Override
    public void update(float delta) {
        if (Objects.equals((Object)((ThrusterSettings)this.settings).operationMode, (Object)ThrusterSettings.OperationMode.HOLD)) {
            float strength = MathUtils.clamp(0.9f - delta, 0.1f, 1.0f);
            this.targetThrust = MathUtils.clamp(this.targetThrust * strength, 0.0f, ((ThrusterSettings)this.settings).maxThrust);
            if (this.targetThrust < threshold) {
                this.targetThrust = 0.0f;
            }
        }
        this.currentThrust = Interpolation.smooth.apply(this.currentThrust, this.targetThrust, 0.4f);
    }
}

