/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.propulsion;

import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.ModuleFunctionSettings;
import java.io.Serializable;
import java.util.Objects;

public class ThrusterSettings
extends ModuleFunctionSettings
implements Serializable {
    private static final long serialVersionUID = -395555522125995378L;
    public String fuelType;
    public String engineSound;
    public String startupSound;
    public float fuelConsumption;
    public float fuelIdleConsumption;
    public String particleEmitter;
    public float maxThrust;
    public float deltaThrust;
    public OperationMode operationMode = OperationMode.THROTTLE;

    public void subtract(ThrusterSettings otherSettings) {
        if (!Objects.equals(this.fuelType, otherSettings.fuelType)) {
            return;
        }
        this.fuelConsumption -= otherSettings.fuelConsumption;
        this.fuelIdleConsumption -= otherSettings.fuelIdleConsumption;
        this.deltaThrust -= otherSettings.deltaThrust;
        this.maxThrust -= otherSettings.maxThrust;
    }

    public void add(ThrusterSettings otherSettings) {
        if (!Objects.equals(this.fuelType, otherSettings.fuelType)) {
            return;
        }
        this.fuelConsumption += otherSettings.fuelConsumption;
        this.fuelIdleConsumption += otherSettings.fuelIdleConsumption;
        this.deltaThrust += otherSettings.deltaThrust;
        this.maxThrust += otherSettings.maxThrust;
    }

    public static enum OperationMode {
        THROTTLE,
        HOLD;

    }
}

