/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors;

import com.neutronio.astrax.app.Message;

public class Metric {
    private float infoThreshold;
    private float warningThreshold;
    private float criticalThreshold;

    public Metric() {
    }

    public Metric(float infoThreshold, float warningThreshold, float criticalThreshold) {
        this.infoThreshold = infoThreshold;
        this.warningThreshold = warningThreshold;
        this.criticalThreshold = criticalThreshold;
    }

    public void setThreshholds(float info, float warning, float critical) {
        this.infoThreshold = info;
        this.warningThreshold = warning;
        this.criticalThreshold = critical;
    }

    public MetricState getState(float forValue) {
        if (forValue <= 0.0f) {
            return MetricState.EMPTY;
        }
        if (forValue < this.criticalThreshold) {
            return MetricState.CRITICAL;
        }
        if (forValue < this.warningThreshold) {
            return MetricState.WARNING;
        }
        if (forValue < this.infoThreshold) {
            return MetricState.INFO;
        }
        return MetricState.NOMINAL;
    }

    public float getMetricValue(float forValue) {
        if (forValue <= 0.0f) {
            return 0.0f;
        }
        if (forValue < this.criticalThreshold) {
            return this.criticalThreshold;
        }
        if (forValue < this.warningThreshold) {
            return this.warningThreshold;
        }
        if (forValue < this.infoThreshold) {
            return this.infoThreshold;
        }
        return -1.0f;
    }

    public float getInfoThreshold() {
        return this.infoThreshold;
    }

    public float getWarningThreshold() {
        return this.warningThreshold;
    }

    public float getCriticalThreshold() {
        return this.criticalThreshold;
    }

    public static enum MetricState {
        NOMINAL,
        INFO,
        WARNING,
        CRITICAL,
        EMPTY;


        public static Message.MessageType toMessageType(MetricState state) {
            switch (state) {
                case NOMINAL: {
                    return Message.MessageType.SUCCESS;
                }
                case INFO: {
                    return Message.MessageType.INFO;
                }
                case WARNING: {
                    return Message.MessageType.WARNING;
                }
                case CRITICAL: {
                    return Message.MessageType.ALERT;
                }
                case EMPTY: {
                    return Message.MessageType.ALERT;
                }
            }
            return null;
        }
    }
}

