/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors;

import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.FunctionalSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors.Metric;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.tanks.TankManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

public class MonitoringSystem
extends FunctionalSystem<Satellite> {
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private float timer = 0.0f;
    private float refreshRate = 1.0f;
    private Map<String, Alert> alerts = new HashMap<String, Alert>();
    private List<MonitoringSystemListener> listeners = new ArrayList<MonitoringSystemListener>();

    public MonitoringSystem(String displayName, Satellite parent) {
        super(displayName, parent);
    }

    public void initializeAlerts() {
        for (TankManager.TankCompartment compartment : ((Satellite)this.getParent()).getTankSystem().getCompartments().values()) {
            Alert alert = new Alert(this, compartment.getResourceID());
            alert.setMetric(this.getDefaultMetric(compartment.getMax()));
            this.addAlert(alert);
        }
    }

    public Alert getAlertFor(String flowSystem) {
        return this.alerts.get(flowSystem);
    }

    public void addListener(MonitoringSystemListener monitoringSystemListener) {
        if (monitoringSystemListener == null) {
            return;
        }
        this.listeners.add(monitoringSystemListener);
    }

    private void addAlert(Alert alert) {
        this.alerts.put(alert.resourceName, alert);
    }

    private Metric getDefaultMetric(float maxValue) {
        return new Metric(maxValue * 0.6f, maxValue * 0.4f, maxValue * 0.2f);
    }

    @Override
    public void update(float delta) {
        this.timer += delta;
        if (this.timer > this.refreshRate) {
            this.timer = 0.0f;
            this.monitor((Satellite)this.getParent());
        }
    }

    public void monitor(Satellite satellite) {
        for (Alert alert : this.alerts.values()) {
            alert.monitor(satellite.getTankCurrent(alert.resourceName));
        }
    }

    private void fireOnMetricDetected(Alert systemAlert, float percentage) {
        for (MonitoringSystemListener listener : this.listeners) {
            listener.onMetricDetected(systemAlert.resourceName, percentage, systemAlert.currentState);
        }
    }

    public class Alert {
        private MonitoringSystem parentSystem;
        protected String resourceName;
        protected Metric metric;
        protected Metric.MetricState currentState = Metric.MetricState.NOMINAL;

        public Alert(MonitoringSystem system, String resourceName) {
            this.resourceName = resourceName;
            this.parentSystem = system;
        }

        public void monitor(float value) {
            Metric.MetricState newState = this.metric.getState(value);
            if (!Objects.equals((Object)this.currentState, (Object)newState)) {
                this.currentState = newState;
                this.parentSystem.fireOnMetricDetected(this, this.metric.getMetricValue(value));
            }
        }

        public void setMetric(Metric metric) {
            this.metric = metric;
        }

        public Metric getMetric() {
            return this.metric;
        }

        public Metric.MetricState getCurrentState() {
            return this.currentState;
        }
    }

    public static interface MonitoringSystemListener {
        public void onMetricDetected(String var1, float var2, Metric.MetricState var3);

        public void onSystemHealthChanged(FunctionalSystem var1, FunctionalSystem.SystemHealth var2, FunctionalSystem.SystemHealth var3);
    }
}

