/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors;

import com.badlogic.gdx.math.Vector2;
import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.datapack.EntityID;
import com.neutronio.astrax.app.datapack.game.DiscoveryTarget;
import com.neutronio.astrax.app.datapack.game.world.BeltTarget;
import com.neutronio.astrax.app.datapack.game.world.SatelliteTarget;
import com.neutronio.astrax.app.datapack.game.world.Targetable;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors.TargetSorter;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.ClassFilter;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.DistanceFilter;
import com.neutronio.astrax.util.AstraXUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ProximitySensor {
    private SatelliteTarget parentTarget;
    private Vector2 parentPosition = new Vector2();
    private float distanceRefreshRate = 0.2f;
    private float time = this.distanceRefreshRate + 0.3f;
    private boolean updateTargetList = true;
    private float maxRange = 0.0f;
    private TargetSorter orbitSorter = new TargetSorter();
    private DistanceFilter distanceFilter = new DistanceFilter();
    private ClassFilter targetFilter = new ClassFilter(BeltTarget.class);

    public ProximitySensor() {
        this.distanceFilter.setDistance(this.maxRange);
    }

    public void setDistanceFilter(DistanceFilter distanceFilter) {
        this.distanceFilter = distanceFilter;
    }

    public ClassFilter getTargetFilter() {
        return this.targetFilter;
    }

    public void setTargetFilter(ClassFilter targetFilter) {
        this.targetFilter = targetFilter;
    }

    public SatelliteTarget getParentTarget() {
        return this.parentTarget;
    }

    public float getMaxRange() {
        return this.maxRange;
    }

    public void setMaxRange(float maxRange) {
        this.maxRange = maxRange;
        this.distanceFilter.setDistance(this.maxRange);
    }

    public void setParentTarget(SatelliteTarget parentTarget) {
        this.parentTarget = parentTarget;
    }

    public boolean isUpdateTargetList() {
        return this.updateTargetList;
    }

    public void setUpdateTargetList(boolean updateTargetList) {
        this.updateTargetList = updateTargetList;
    }

    public DistanceFilter getDistanceFilter() {
        return this.distanceFilter;
    }

    public boolean containsTarget(Targetable actor) {
        return this.orbitSorter.contains(actor.getID());
    }

    public void addTarget(DiscoveryTarget discoveryTarget) {
        this.orbitSorter.addTarget(discoveryTarget);
    }

    public void removeTarget(DiscoveryTarget discoveryTarget) {
        this.orbitSorter.removeTarget(discoveryTarget);
    }

    public void removeTarget(EntityID entityID) {
        this.orbitSorter.removeTarget(entityID);
    }

    public List<TargetSorter.Target> getTargets_WithinDistance(boolean includeSelf) {
        List<TargetSorter.Target> targets = this.orbitSorter.getTargets(this.targetFilter, this.distanceFilter);
        if (!includeSelf && this.parentTarget != null) {
            for (TargetSorter.Target target : targets) {
                if (!Objects.equals(target.getTargetable().getID(), this.parentTarget.getID())) continue;
                targets.remove(target);
                break;
            }
        }
        return targets;
    }

    public List<TargetSorter.Target> getTargets_DiscoveredWithinDistance(boolean includeSelf) {
        List<TargetSorter.Target> targets = this.orbitSorter.getTargets(this.targetFilter, this.distanceFilter);
        if (!includeSelf && this.parentTarget != null) {
            for (TargetSorter.Target target : targets) {
                if (!Objects.equals(target.getTargetable().getID(), this.parentTarget.getID())) continue;
                targets.remove(target);
                break;
            }
        }
        return targets;
    }

    public List<TargetSorter.Target> getAllTargets() {
        return this.orbitSorter.getTargets();
    }

    @Deprecated
    public List<TargetSorter.Target> getTargets() {
        return this.orbitSorter.getTargets(this.maxRange);
    }

    public List<TargetSorter.Target> getAllTargets(int count) {
        ArrayList<TargetSorter.Target> list = new ArrayList<TargetSorter.Target>();
        List<TargetSorter.Target> targets = this.orbitSorter.getTargets(this.targetFilter);
        if (targets.isEmpty()) {
            return list;
        }
        int min = Math.min(count, targets.size());
        int currentTarget = 0;
        int added = 0;
        do {
            if (Objects.equals(targets.get(currentTarget).getTargetable().getID(), this.parentTarget.getID())) continue;
            list.add(targets.get(currentTarget));
            ++added;
        } while (added < min && ++currentTarget < targets.size());
        return list;
    }

    public TargetSorter.Target getClosestTarget() {
        List<TargetSorter.Target> orbitDistances = this.getTargets_WithinDistance(false);
        if (orbitDistances.isEmpty()) {
            return null;
        }
        return orbitDistances.get(0);
    }

    public boolean isInScannerRange(Targetable targetable) {
        return this.orbitSorter.inRange(targetable.getID(), this.maxRange);
    }

    public void setTargets(List<DiscoveryTarget> targets) {
        this.orbitSorter.setTargets(targets);
    }

    public void calculateTargetInformation() {
        if (this.parentTarget == null) {
            throw new AstraXException(AstraXException.ErrorCode.E0001, "Parent target must be defined!");
        }
        this.parentPosition.set(0.0f, 0.0f);
        AstraXUtil.getWorldPosition(this.parentPosition, this.parentTarget.getGraphics());
        this.orbitSorter.calculate(this.parentPosition.x, this.parentPosition.y);
        this.orbitSorter.sort();
        this.time = 0.0f;
    }

    public void calculateTargetInformation(float x, float y) {
        this.orbitSorter.calculate(x, y);
        this.orbitSorter.sort();
    }

    public void update(float delta) {
        this.time += delta;
        if (this.time > this.distanceRefreshRate && this.updateTargetList) {
            this.calculateTargetInformation();
        }
    }
}

