/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors;

import com.badlogic.gdx.math.MathUtils;
import com.neutronio.astrax.app.datapack.game.world.CelestialTarget;
import com.neutronio.astrax.app.datapack.game.world.Targetable;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors.TargetSorter;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.Planet;
import com.neutronio.astrax.sfx.SoundManager;
import com.neutronio.astrax.util.MathUtil;
import java.util.List;

public class RadiationSensor {
    public static final float maxRadiation = 6.0f;
    private SoundManager soundManager;
    private float detectedRadiation;
    private float time;
    private float interval = 0.03f;
    private boolean playSound = true;

    public RadiationSensor(SoundManager soundManager) {
        this.soundManager = soundManager;
    }

    public void update(float delta, List<TargetSorter.Target> targets) {
        if (this.playSound) {
            this.time -= delta;
            if (this.time < 0.0f && this.detectedRadiation > 0.5f) {
                this.time = (6.0f - this.detectedRadiation) * this.interval;
                int randomIndex = MathUtil.getRandomInteger(8);
                this.soundManager.playSoundOnce("geiger" + randomIndex);
            }
        }
        float currentRadiation = 0.0f;
        for (TargetSorter.Target target : targets) {
            Targetable actor = target.getTargetable();
            if (!(actor instanceof CelestialTarget) || !(target.getDistance() < 2000.0f)) continue;
            Planet planet = (Planet)actor.getModel();
            float distanceFactor = target.getDistance() / 2000.0f;
            currentRadiation = MathUtils.clamp(currentRadiation, 0.0f, 6.0f) * (1.0f - distanceFactor);
        }
        this.detectedRadiation = this.detectedRadiation * 0.9f + currentRadiation * 0.1f;
    }

    public boolean isPlaySound() {
        return this.playSound;
    }

    public void setPlaySound(boolean playSound) {
        this.playSound = playSound;
    }

    public float getDetectedRadiation() {
        return this.detectedRadiation;
    }

    public float getDetectedRadiationFactor() {
        return this.detectedRadiation / 6.0f;
    }
}

