/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors;

import com.neutronio.astrax.app.datapack.EntityID;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors.ProximitySensor;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors.SonarListener;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors.TargetSorter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Sonar {
    private ProximitySensor proximitySensor;
    private List<SonarListener> listeners = new ArrayList<SonarListener>();
    private Map<EntityID, TargetSorter.Target> actorsInRange = new LinkedHashMap<EntityID, TargetSorter.Target>();

    public Sonar(ProximitySensor proximitySensor) {
        this.proximitySensor = proximitySensor;
    }

    public void addListener(SonarListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    private void fireOnTargetDetected(TargetSorter.Target target) {
        for (SonarListener listener : this.listeners) {
            listener.onTargetDetected(target);
        }
    }

    private void fireOnTargetLost(TargetSorter.Target target) {
        for (SonarListener listener : this.listeners) {
            listener.onTargetLost(target);
        }
    }

    public void scan() {
        List<TargetSorter.Target> sonarTargets = this.proximitySensor.getTargets_WithinDistance(false);
        for (TargetSorter.Target target : sonarTargets) {
            EntityID id = target.getTargetable().getID();
            if (this.actorsInRange.containsKey(id)) continue;
            this.actorsInRange.put(id, target);
            this.fireOnTargetDetected(target);
        }
        ArrayList<TargetSorter.Target> toRemove = new ArrayList<TargetSorter.Target>();
        for (TargetSorter.Target existingActor : this.actorsInRange.values()) {
            boolean targetLost = true;
            EntityID id = existingActor.getTargetable().getID();
            for (TargetSorter.Target newTarget : sonarTargets) {
                EntityID newId = newTarget.getTargetable().getID();
                if (!Objects.equals(id, newId)) continue;
                targetLost = false;
            }
            if (!targetLost) continue;
            toRemove.add(existingActor);
        }
        for (TargetSorter.Target actor : toRemove) {
            EntityID id = actor.getTargetable().getID();
            this.actorsInRange.remove(id);
            this.fireOnTargetLost(actor);
        }
    }

    public String toString() {
        return "Sonar{actorsInRange=" + this.actorsInRange + '}';
    }
}

