/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors;

import com.badlogic.gdx.math.Vector2;
import com.neutronio.astrax.app.datapack.EntityID;
import com.neutronio.astrax.app.datapack.game.DiscoveryTarget;
import com.neutronio.astrax.app.datapack.game.world.NavTarget;
import com.neutronio.astrax.app.datapack.game.world.Targetable;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.TargetFilter;
import com.neutronio.astrax.util.AstraXUtil;
import com.neutronio.astrax.util.MathUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class TargetSorter {
    private DistanceComparator comparator = new DistanceComparator();
    private List<Target> targets = new ArrayList<Target>();

    public static Target newTarget(float distance, float angle) {
        Target target = new Target(null, distance);
        target.angle = angle;
        return target;
    }

    public List<Target> getTargets(TargetFilter ... filters) {
        ArrayList<Target> copy = new ArrayList<Target>();
        for (Target target : this.targets) {
            boolean keepTarget = true;
            for (TargetFilter filter : filters) {
                if (filter == null) continue;
                keepTarget = keepTarget && filter.isIncluded(target);
            }
            if (!keepTarget) continue;
            copy.add(target);
        }
        return copy;
    }

    public List<Target> getTargets() {
        ArrayList<Target> copy = new ArrayList<Target>();
        copy.addAll(this.targets);
        return copy;
    }

    @Deprecated
    public List<Target> getTargets(float maxDistance) {
        ArrayList<Target> result = new ArrayList<Target>();
        for (Target orbit : this.targets) {
            if (!(orbit.getDistance() < maxDistance)) continue;
            result.add(orbit);
        }
        return result;
    }

    public void setTargets(List<DiscoveryTarget> discoveries) {
        this.targets.clear();
        for (DiscoveryTarget discoveryTarget : discoveries) {
            this.targets.add(new Target(discoveryTarget));
        }
    }

    public void addTargetTest(Targetable actor, float distance) {
        if (actor == null) {
            return;
        }
        Target target = new Target(new DiscoveryTarget<Targetable>(null, actor), distance);
        this.targets.add(target);
    }

    public void addTarget(Targetable actor) {
        this.addTargetTest(actor, 0.0f);
    }

    public void addTarget(DiscoveryTarget discoveryTarget) {
        Target target = new Target(discoveryTarget, 0.0f);
        this.targets.add(target);
    }

    public void removeTarget(DiscoveryTarget discoveryTarget) {
        this.targets.remove(discoveryTarget);
    }

    public void removeTarget(EntityID entityID) {
        int i2 = 0;
        for (Target target : this.targets) {
            if (Objects.equals(((Target)target).discoveryTarget.target.getID(), entityID)) break;
            ++i2;
        }
        if (i2 != this.targets.size()) {
            this.targets.remove(i2);
        }
    }

    public boolean contains(EntityID entityID) {
        for (Target target : this.targets) {
            if (!Objects.equals(((Target)target).discoveryTarget.target.getID(), entityID)) continue;
            return true;
        }
        return false;
    }

    public boolean inRange(EntityID entityID, float distance) {
        for (Target target : this.targets) {
            if (!Objects.equals(((Target)target).discoveryTarget.target.getID(), entityID) || !(target.distance < distance)) continue;
            return true;
        }
        return false;
    }

    public void calculate(float centerX, float centerY) {
        for (Target target : this.targets) {
            if (target.getTargetable() instanceof NavTarget) {
                NavTarget navTarget = (NavTarget)target.getTargetable();
                target.worldpos.set(navTarget.getWorldPositionX(), navTarget.getWorldPositionY());
                target.angle = MathUtil.getAngleBetweenVectors(target.worldpos, centerX, centerY);
                target.distance = Vector2.dst(centerX, centerY, centerX - target.worldpos.x, centerY - target.worldpos.y);
                continue;
            }
            target.worldpos.setZero();
            AstraXUtil.getWorldPosition(target.worldpos, target.getTargetable().getGraphics());
            target.angle = MathUtil.getAngleBetweenVectors(target.worldpos, centerX, centerY);
            target.distance = Vector2.dst(centerX, centerY, centerX - target.worldpos.x, centerY - target.worldpos.y);
        }
    }

    public void sort() {
        Collections.sort(this.targets, this.comparator);
    }

    private class DistanceComparator
    implements Comparator<Target> {
        private DistanceComparator() {
        }

        @Override
        public int compare(Target o1, Target o2) {
            if (o1.distance < o2.distance) {
                return -1;
            }
            if (o1.distance > o2.distance) {
                return 1;
            }
            return 0;
        }
    }

    public static class Target {
        private DiscoveryTarget discoveryTarget;
        protected float distance;
        protected float angle;
        protected Vector2 worldpos = new Vector2();

        public Target(DiscoveryTarget discoveryTarget) {
            this.discoveryTarget = discoveryTarget;
        }

        public Target(DiscoveryTarget discoveryTarget, float distance) {
            this.discoveryTarget = discoveryTarget;
            this.distance = distance;
        }

        public DiscoveryTarget getDiscoveryTarget() {
            return this.discoveryTarget;
        }

        public Targetable getTargetable() {
            return this.discoveryTarget.target;
        }

        public float getDistance() {
            return this.distance;
        }

        public float getAngle() {
            return this.angle;
        }

        public void setAngle(float angle) {
            this.angle = angle;
        }

        public void setDistance(float distance) {
            this.distance = distance;
        }

        public String toString() {
            return "Target{actor=" + this.discoveryTarget.target + ", distance=" + this.distance + ", angle=" + this.angle + '}';
        }
    }
}

