/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.tanks;

import com.badlogic.gdx.math.MathUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TankManager {
    private Map<Integer, Float> priority = new HashMap<Integer, Float>();
    private Map<String, TankCompartment> compartments = new HashMap<String, TankCompartment>();
    private ConsumerComparator comparator = new ConsumerComparator();

    public TankManager() {
        this.priority = new HashMap<Integer, Float>();
        this.priority.put(0, Float.valueOf(0.1f));
        this.priority.put(1, Float.valueOf(0.2f));
        this.priority.put(2, Float.valueOf(0.5f));
        this.priority.put(3, Float.valueOf(0.7f));
        this.priority.put(4, Float.valueOf(0.9f));
        this.priority.put(5, Float.valueOf(1.0f));
    }

    public Map<String, TankCompartment> getCompartments() {
        return this.compartments;
    }

    public boolean hasCompartment(String id) {
        return this.compartments.containsKey(id);
    }

    public TankCompartment getCompartment(String id) {
        return this.compartments.get(id);
    }

    public List<TankCompartment> getCompartments(String resourceID) {
        return null;
    }

    public void createCompartment(String resource) {
        TankCompartment compartment = new TankCompartment();
        compartment.resourceID = resource;
        this.compartments.put(resource, compartment);
    }

    public void createCompartment(String id, String resource) {
        TankCompartment compartment = new TankCompartment();
        compartment.resourceID = resource;
        this.compartments.put(id, compartment);
    }

    public float refillCompartment(String compartmentId, float amount) {
        return this.compartments.get(compartmentId).refill(amount);
    }

    public void addToCompartment(String compartmentId, Tank tank) {
        this.compartments.get(compartmentId).connect(tank);
    }

    public void addToCompartment(String compartmentId, Consumer consumer) {
        this.compartments.get(compartmentId).connect(consumer);
    }

    public void addToCompartment(String compartmentId, Producer producer) {
        this.compartments.get(compartmentId).connect(producer);
    }

    public void calculateTankDistribution() {
        for (TankCompartment compartment : this.compartments.values()) {
            compartment.calculateTankDistribution();
        }
    }

    public void update(float delta) {
        for (TankCompartment compartment : this.compartments.values()) {
            compartment.update(delta);
        }
    }

    public static Producer getProducer(float production) {
        return new DummyProducer(production);
    }

    public static Consumer getConsumer(float consumption, int priority) {
        return new DummyConsumer(priority, consumption);
    }

    public static void consumerMalfunction() {
        TankManager tankSystem = new TankManager();
        tankSystem.createCompartment("oxygen");
        tankSystem.addToCompartment("oxygen", new DummyTank(100.0f, 100.0f));
        tankSystem.addToCompartment("oxygen", new DummyTank(100.0f, 100.0f));
        tankSystem.addToCompartment("oxygen", TankManager.getConsumer(0.2f, 5));
        tankSystem.addToCompartment("oxygen", TankManager.getConsumer(0.3f, 5));
        tankSystem.addToCompartment("oxygen", TankManager.getConsumer(1.5f, 5));
        tankSystem.addToCompartment("oxygen", TankManager.getProducer(0.2f));
        tankSystem.addToCompartment("oxygen", TankManager.getProducer(0.3f));
        tankSystem.addToCompartment("oxygen", TankManager.getProducer(1.45f));
        for (int i2 = 0; i2 < 10; ++i2) {
            tankSystem.update(1.0f);
            System.out.println(tankSystem.compartments.get("oxygen").production);
            System.out.println(tankSystem.compartments.get("oxygen").consumption);
            System.out.println(tankSystem.compartments.get("oxygen").stored);
            System.out.println("===");
        }
        System.out.println(tankSystem.compartments.get("oxygen").stored);
        System.out.println(tankSystem.compartments.get("oxygen").max);
    }

    public static void updateUntilEmpty() {
        TankManager tankSystem = new TankManager();
        tankSystem.createCompartment("oxygen");
        tankSystem.addToCompartment("oxygen", new DummyTank(100.0f, 100.0f));
        tankSystem.addToCompartment("oxygen", new DummyTank(100.0f, 100.0f));
        tankSystem.addToCompartment("oxygen", TankManager.getConsumer(0.2f, 5));
        tankSystem.addToCompartment("oxygen", TankManager.getConsumer(0.3f, 5));
        tankSystem.addToCompartment("oxygen", TankManager.getConsumer(1.5f, 5));
        tankSystem.addToCompartment("oxygen", TankManager.getProducer(0.2f));
        tankSystem.addToCompartment("oxygen", TankManager.getProducer(0.3f));
        tankSystem.addToCompartment("oxygen", TankManager.getProducer(1.45f));
        for (int i2 = 0; i2 < 10; ++i2) {
            tankSystem.update(1.0f);
            System.out.println(tankSystem.compartments.get("oxygen").production);
            System.out.println(tankSystem.compartments.get("oxygen").consumption);
            System.out.println(tankSystem.compartments.get("oxygen").stored);
            System.out.println("===");
        }
        System.out.println(tankSystem.compartments.get("oxygen").stored);
        System.out.println(tankSystem.compartments.get("oxygen").max);
    }

    public static void updateUntilFull() {
        TankManager tankSystem = new TankManager();
        tankSystem.createCompartment("oxygen");
        tankSystem.addToCompartment("oxygen", new DummyTank(100.0f, 100.0f));
        tankSystem.addToCompartment("oxygen", new DummyTank(100.0f, 100.0f));
        tankSystem.addToCompartment("oxygen", TankManager.getConsumer(0.2f, 5));
        tankSystem.addToCompartment("oxygen", TankManager.getConsumer(0.3f, 5));
        tankSystem.addToCompartment("oxygen", TankManager.getConsumer(1.45f, 5));
        tankSystem.addToCompartment("oxygen", TankManager.getProducer(0.2f));
        tankSystem.addToCompartment("oxygen", TankManager.getProducer(0.3f));
        tankSystem.addToCompartment("oxygen", TankManager.getProducer(1.5f));
        for (int i2 = 0; i2 < 10; ++i2) {
            tankSystem.update(1.0f);
            System.out.println(tankSystem.compartments.get("oxygen").production);
            System.out.println(tankSystem.compartments.get("oxygen").consumption);
            System.out.println(tankSystem.compartments.get("oxygen").stored);
            System.out.println("===");
        }
        System.out.println(tankSystem.compartments.get("oxygen").stored);
        System.out.println(tankSystem.compartments.get("oxygen").max);
    }

    public static void main(String[] args) {
        TankManager tankSystem = new TankManager();
        tankSystem.createCompartment("oxygen");
        tankSystem.addToCompartment("oxygen", new DummyTank(100.0f, 100.0f));
        tankSystem.addToCompartment("oxygen", new DummyTank(100.0f, 100.0f));
        tankSystem.addToCompartment("oxygen", TankManager.getConsumer(0.2f, 5));
        tankSystem.addToCompartment("oxygen", TankManager.getConsumer(0.3f, 5));
        tankSystem.addToCompartment("oxygen", TankManager.getConsumer(1.45f, 5));
        tankSystem.addToCompartment("oxygen", TankManager.getProducer(0.2f));
        tankSystem.addToCompartment("oxygen", TankManager.getProducer(0.3f));
        tankSystem.addToCompartment("oxygen", TankManager.getProducer(1.5f));
        for (int i2 = 0; i2 < 10; ++i2) {
            tankSystem.update(1.0f);
            System.out.println(tankSystem.compartments.get("oxygen").production);
            System.out.println(tankSystem.compartments.get("oxygen").consumption);
            System.out.println(tankSystem.compartments.get("oxygen").stored);
            System.out.println("===");
        }
        System.out.println(tankSystem.compartments.get("oxygen").stored);
        System.out.println(tankSystem.compartments.get("oxygen").max);
    }

    public class ConsumerComparator
    implements Comparator<Consumer> {
        @Override
        public int compare(Consumer o1, Consumer o2) {
            return Integer.compare(o1.getPriority(), o2.getPriority());
        }
    }

    public class TankCompartment {
        private String resourceID = "";
        private float production;
        private float maxProduction;
        private float consumption;
        private float maxConsumption;
        private float _production;
        private float _consumption;
        private float stored = 0.0f;
        private float max = 0.0f;
        private List<Tank> tanks = new ArrayList<Tank>();
        private List<Consumer> consumers = new ArrayList<Consumer>();
        private List<Producer> producers = new ArrayList<Producer>();

        public void fill(float amount) {
            this.stored += Math.abs(amount);
        }

        public void drain(float amount) {
            this.stored -= Math.abs(amount);
        }

        public List<Tank> getTanks() {
            return this.tanks;
        }

        public List<Consumer> getConsumers() {
            return this.consumers;
        }

        public List<Producer> getProducers() {
            return this.producers;
        }

        public float getMaxProduction() {
            return this.maxProduction;
        }

        public float getMaxConsumption() {
            return this.maxConsumption;
        }

        public String getResourceID() {
            return this.resourceID;
        }

        public float getProduction() {
            return this.production;
        }

        public float getConsumption() {
            return this.consumption;
        }

        public float getStored() {
            return this.stored;
        }

        public float getStoredFactor() {
            return this.stored / this.max;
        }

        public float getMax() {
            return this.max;
        }

        public void connect(Producer producer) {
            if (producer == null) {
                return;
            }
            this.producers.add(producer);
            this.maxProduction += producer.getMaxProduction();
        }

        public float refill(float amount) {
            float old = this.stored;
            this.stored = MathUtils.clamp(this.stored + amount, 0.0f, this.max);
            return old - this.stored;
        }

        public void disconnect(Producer producer) {
            if (producer == null) {
                return;
            }
            this.producers.remove(producer);
            this.maxProduction -= producer.getMaxProduction();
        }

        public void connect(Tank tank) {
            if (tank == null) {
                return;
            }
            this.tanks.add(tank);
            this.stored += tank.getStored();
            this.max += tank.getMax();
        }

        public void disconnect(Tank tank) {
            if (tank == null) {
                return;
            }
            this.tanks.remove(tank);
            this.stored -= tank.getStored();
            this.max -= tank.getMax();
        }

        public void connect(Consumer consumer) {
            if (consumer == null) {
                return;
            }
            this.consumers.add(consumer);
            this.maxConsumption += consumer.getMaxDemand();
            Collections.sort(this.consumers, TankManager.this.comparator);
        }

        public void disconnect(Consumer consumer) {
            if (consumer == null) {
                return;
            }
            this.consumers.remove(consumer);
            this.maxConsumption -= consumer.getMaxDemand();
            Collections.sort(this.consumers, TankManager.this.comparator);
        }

        public void calculateTankDistribution() {
            for (Tank tank : this.tanks) {
                tank.setDistributionRate(tank.getMax() / this.max);
            }
        }

        private void calculateProduction() {
            this._production = 0.0f;
            float produced = 0.0f;
            for (Producer producer : this.producers) {
                produced = producer.getProduction() * (producer.getHealthEfficiency() * producer.getResourceEfficiency());
                this._production += produced;
            }
            this.production = this._production;
        }

        private void commitRates(float delta) {
            this.stored = MathUtils.clamp(this.stored + (this._production - this._consumption) * delta, 0.0f, this.max);
        }

        private void calculateConsumption() {
            this._consumption = 0.0f;
            float resourceFeedFactor = 0.0f;
            float demand = 0.0f;
            for (Consumer module : this.consumers) {
                resourceFeedFactor = (TankManager.this.priority.containsKey(module.getPriority()) ? (Float)TankManager.this.priority.get(module.getPriority()) : (Float)TankManager.this.priority.get(5)).floatValue();
                demand = module.getDemand() * resourceFeedFactor * module.getHealthEfficiency();
                if (demand > this.stored) {
                    module.applyEfficiency(0.0f);
                } else {
                    module.applyEfficiency(resourceFeedFactor);
                }
                this._consumption += demand;
            }
            this.consumption = this._consumption;
        }

        private void distribute() {
            for (Tank tank : this.tanks) {
                tank.setStored(this.stored * tank.getDistributionRate());
            }
        }

        public void update(float delta) {
            this.calculateProduction();
            this.calculateConsumption();
            this.commitRates(delta);
            if (this.stored == 0.0f) {
                return;
            }
            this.distribute();
        }
    }

    public static interface Tank {
        public float getDistributionRate();

        public void setDistributionRate(float var1);

        public void setStored(float var1);

        public float getMax();

        public float getStored();

        public String getName();
    }

    public static interface Consumer {
        public float getDemand();

        public float getMaxDemand();

        public int getPriority();

        public void applyEfficiency(float var1);

        public float getHealthEfficiency();

        public float getResourceEfficiency();

        public String getName();
    }

    public static interface Producer {
        public float getProduction();

        public float getMaxProduction();

        public void applyEfficiency(float var1);

        public float getHealthEfficiency();

        public float getResourceEfficiency();

        public String getName();
    }

    private static class DummyProducer
    implements Producer {
        float healthEfficiency = 1.0f;
        float resourceEfficiency = 1.0f;
        float production = 0.0f;

        public DummyProducer(float production) {
            this.production = production;
        }

        @Override
        public float getProduction() {
            return this.production;
        }

        @Override
        public float getMaxProduction() {
            return 2.0f;
        }

        @Override
        public void applyEfficiency(float efficiency) {
        }

        @Override
        public float getHealthEfficiency() {
            return this.healthEfficiency;
        }

        @Override
        public float getResourceEfficiency() {
            return this.resourceEfficiency;
        }

        @Override
        public String getName() {
            return null;
        }
    }

    private static class DummyConsumer
    implements Consumer {
        int priority = 0;
        float demand = 0.0f;
        float healthEfficiency = 1.0f;
        float resourceEfficiency = 1.0f;

        public DummyConsumer(int priority, float demand) {
            this.priority = priority;
            this.demand = demand;
        }

        @Override
        public float getDemand() {
            return this.demand;
        }

        @Override
        public float getMaxDemand() {
            return 2.0f;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public void applyEfficiency(float efficiency) {
        }

        @Override
        public float getHealthEfficiency() {
            return this.healthEfficiency;
        }

        @Override
        public float getResourceEfficiency() {
            return this.resourceEfficiency;
        }

        @Override
        public String getName() {
            return null;
        }
    }

    public static class DummyTank
    implements Tank {
        float stored = 0.0f;
        float max = 0.0f;
        float distribution = 0.0f;

        public DummyTank(float stored, float max) {
            this.stored = stored;
            this.max = max;
        }

        @Override
        public float getDistributionRate() {
            return this.distribution;
        }

        @Override
        public void setDistributionRate(float stored) {
            this.distribution = stored;
        }

        @Override
        public void setStored(float stored) {
            this.stored = stored;
        }

        @Override
        public float getMax() {
            return this.max;
        }

        @Override
        public float getStored() {
            return this.stored;
        }

        @Override
        public String getName() {
            return null;
        }
    }
}

