/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.tanks;

import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.FunctionalSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.Module;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.ModuleFunction;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.Tank;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.mining.MiningDrill;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.propulsion.TankSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.propulsion.Thruster;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.tanks.GenericConsumer;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.tanks.GenericProducer;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.tanks.MiningDrillConsumer;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.tanks.StorageTank;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.tanks.TankManager;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.tanks.ThrusterConsumer;
import java.util.Map;

public class TankSystem
extends FunctionalSystem<Satellite> {
    protected TankManager tankManager = new TankManager();
    protected boolean active = true;

    public TankSystem() {
    }

    public TankSystem(String displayName, Satellite parent) {
        super(displayName, parent);
    }

    public TankManager getTankManager() {
        return this.tankManager;
    }

    public Map<String, TankManager.TankCompartment> getCompartments() {
        return this.tankManager.getCompartments();
    }

    public void activate() {
        this.active = true;
    }

    public void deactivate() {
        this.active = false;
    }

    public boolean hasTank(String resourceID) {
        return this.tankManager.hasCompartment(resourceID);
    }

    public void addModule(Module module) {
        for (ModuleFunction moduleFunction : module.getTankFunctionality()) {
            if (moduleFunction.getUsedResourceID() == null) continue;
            if (!this.tankManager.hasCompartment(moduleFunction.getUsedResourceID())) {
                this.tankManager.createCompartment(moduleFunction.getUsedResourceID());
            }
            if (!(moduleFunction instanceof Tank)) continue;
            Tank tank = (Tank)moduleFunction;
            if (((TankSettings)tank.getSettings()).capacity > 0.0f) {
                this.tankManager.addToCompartment(moduleFunction.getUsedResourceID(), new StorageTank(tank));
            }
            if (((TankSettings)tank.getSettings()).consumption > 0.0f) {
                this.tankManager.addToCompartment(moduleFunction.getUsedResourceID(), new GenericConsumer<Tank>(tank){

                    @Override
                    public float getDemand() {
                        return ((TankSettings)((Tank)this.function).getSettings()).consumption;
                    }

                    @Override
                    public float getMaxDemand() {
                        return ((TankSettings)((Tank)this.function).getSettings()).consumption;
                    }
                });
            }
            if (!(((TankSettings)tank.getSettings()).production > 0.0f)) continue;
            this.tankManager.addToCompartment(moduleFunction.getUsedResourceID(), new GenericProducer<Tank>(tank){

                @Override
                public float getProduction() {
                    return ((TankSettings)((Tank)this.function).getSettings()).production;
                }

                @Override
                public float getMaxProduction() {
                    return ((TankSettings)((Tank)this.function).getSettings()).production;
                }
            });
        }
        for (ModuleFunction moduleFunction : module.getFunctionality()) {
            if (moduleFunction.getUsedResourceID() == null) continue;
            if (!this.tankManager.hasCompartment(moduleFunction.getUsedResourceID())) {
                this.tankManager.createCompartment(moduleFunction.getUsedResourceID());
            }
            if (moduleFunction instanceof MiningDrill) {
                this.tankManager.addToCompartment(moduleFunction.getUsedResourceID(), new MiningDrillConsumer((MiningDrill)moduleFunction));
                continue;
            }
            if (!(moduleFunction instanceof Thruster)) continue;
            this.tankManager.addToCompartment(moduleFunction.getUsedResourceID(), new ThrusterConsumer((Thruster)moduleFunction));
        }
    }

    public void calculateTankDistribution() {
        this.tankManager.calculateTankDistribution();
    }

    public float refill(String resource, float amount) {
        return this.tankManager.refillCompartment(resource, amount);
    }

    @Override
    public void update(float delta) {
        this.tankManager.update(delta);
    }
}

