/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting;

import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.EntityID;
import com.neutronio.astrax.app.datapack.game.DiscoveryTarget;
import com.neutronio.astrax.app.datapack.game.mechanics.resources.Resource;
import com.neutronio.astrax.app.datapack.game.world.AsteroidTarget;
import com.neutronio.astrax.app.datapack.game.world.CelestialTarget;
import com.neutronio.astrax.app.datapack.game.world.galaxy.asteroid.Asteroid;
import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.PlanetTrait;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.Planet;
import com.neutronio.astrax.util.collections.GroupedMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class DiscoveryDatabank {
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private Map<EntityID, DiscoveryTarget> discoveries = new LinkedHashMap<EntityID, DiscoveryTarget>();
    private GroupedMap<Object, String> childDiscoveries = new GroupedMap();

    public Map<EntityID, DiscoveryTarget> getDiscoveries() {
        return this.discoveries;
    }

    public float getDiscoveredFactor() {
        int knownObjects = 0;
        for (DiscoveryTarget discovery : this.discoveries.values()) {
            if (discovery.discovery == null) continue;
            ++knownObjects;
        }
        return (float)knownObjects / (float)this.discoveries.size();
    }

    public void addDiscovery(DiscoveryTarget discoveryTarget) {
        this.discoveries.put(discoveryTarget.target.getID(), discoveryTarget);
    }

    public void initWithDiscoveries(List<DiscoveryTarget> discoveries) {
        this.discoveries.clear();
        for (DiscoveryTarget discovery : discoveries) {
            this.discoveries.put(discovery.target.getID(), discovery);
        }
    }

    public void setChildDiscoveries(GroupedMap<Object, String> childDiscoveries) {
        this.childDiscoveries = childDiscoveries;
    }

    public void addChildDiscovery(EntityID entityId, String archetypeId) {
        this.childDiscoveries.addToGroup(entityId.get(), archetypeId);
    }

    public List<String> getChildDiscoveries(EntityID entityId) {
        return this.childDiscoveries.getElements(entityId.get());
    }

    public DiscoveryTarget getDiscoveryOf(EntityID entityID) {
        return this.discoveries.get(entityID);
    }

    public List<String> getIconsFor(EntityID entityID) {
        ArrayList<String> icons;
        block7: {
            DiscoveryTarget discoveryTarget;
            block6: {
                icons = new ArrayList<String>();
                discoveryTarget = this.getDiscoveryOf(entityID);
                if (discoveryTarget == null) {
                    return icons;
                }
                if (!(discoveryTarget.target instanceof AsteroidTarget)) break block6;
                AsteroidTarget asteroidTarget = (AsteroidTarget)discoveryTarget.target;
                List<String> knownResources = this.getChildDiscoveries(entityID);
                List<String> resources = ((Asteroid)asteroidTarget.getModel()).getResourceDeposit().getResourceSettings().resources.values();
                for (String resourceID : resources) {
                    if (knownResources != null && knownResources.contains(resourceID)) {
                        icons.add(((Resource)AstraXApp.astraX.findResource((String)resourceID)).icon);
                        continue;
                    }
                    icons.add("icon_inline_questionmark");
                }
                break block7;
            }
            if (!(discoveryTarget.target instanceof CelestialTarget)) break block7;
            CelestialTarget celestialTarget = (CelestialTarget)discoveryTarget.target;
            List<String> knownTraits = this.getChildDiscoveries(entityID);
            if (knownTraits != null) {
                List<String> traits = ((Planet)celestialTarget.getModel()).getCustomPlanetSettings().traits;
                List planetTraits = AstraXApp.astraX.getRepositoryFactory().findResourcesByIDs(knownTraits);
                for (PlanetTrait planetTrait : planetTraits) {
                    icons.add(planetTrait.icon);
                }
                for (int i2 = 0; i2 < traits.size() - knownTraits.size(); ++i2) {
                    icons.add("icon_inline_questionmark");
                }
            }
        }
        return icons;
    }

    public void clearSystemTargets() {
        this.discoveries.clear();
    }
}

