/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting;

import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.datapack.game.DiscoveryTarget;
import com.neutronio.astrax.app.datapack.game.mechanics.discovery.DiscoveryListener;
import com.neutronio.astrax.app.datapack.game.world.CelestialTarget;
import com.neutronio.astrax.app.datapack.game.world.Discovery;
import com.neutronio.astrax.app.datapack.game.world.GalaxyMapContext;
import com.neutronio.astrax.app.datapack.game.world.SatelliteTarget;
import com.neutronio.astrax.app.datapack.game.world.Targetable;
import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.PlanetTrait;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors.ProximitySensor;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.DiscoveryDatabank;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.Planet;
import com.neutronio.astrax.app.screen.SpaceScreen;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DiscoveryScanner {
    private GalaxyMapContext galaxyMapContext;
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private DiscoveryDatabank databank;
    private List<DiscoveryListener> discoveryListeners = new ArrayList<DiscoveryListener>();

    public void addDiscoveryListener(DiscoveryListener discoveryListener) {
        if (discoveryListener != null) {
            this.discoveryListeners.add(discoveryListener);
        }
    }

    public void setGalaxyMapContext(GalaxyMapContext galaxyMapContext) {
        this.galaxyMapContext = galaxyMapContext;
    }

    public DiscoveryScanner(DiscoveryDatabank databank) {
        this.databank = databank;
    }

    public DiscoveryDatabank getDatabank() {
        return this.databank;
    }

    public void setDatabank(DiscoveryDatabank databank) {
        this.databank = databank;
    }

    public void scanTarget(ProximitySensor sensor, DiscoveryTarget target) {
        boolean isTarget = sensor.containsTarget((Targetable)target.target);
        if (target != null && isTarget) {
            try {
                Discovery discovery = this.galaxyMapContext.getDiscoveryDAO().getByEntityId(target.target.getID().get());
                if (discovery == null) {
                    this.addNewTarget(target);
                } else {
                    this.addTraitsToDiscovery(target);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private void addNewTarget(DiscoveryTarget target) throws SQLException {
        if (target.discovery == null) {
            target.discovery = this.galaxyMapContext.getDiscoveryFactory().createDiscovery((Targetable)target.target);
            if (target.target instanceof CelestialTarget) {
                target.discovery.starSystemId = AstraXApp.astraX.getScreen(SpaceScreen.class).getAstraxGame().getWorld().getSectorStream().getCurrentSector().getTileID();
            }
            this.galaxyMapContext.getDiscoveryDAO().insert(target.discovery);
            for (DiscoveryListener listener : this.discoveryListeners) {
                listener.onDiscovery(target);
            }
        }
    }

    private void addTraitsToDiscovery(DiscoveryTarget target) throws SQLException {
        if (target.target instanceof CelestialTarget) {
            CelestialTarget celestialTarget = (CelestialTarget)target.target;
            int allTraits = ((Planet)celestialTarget.getModel()).getCustomPlanetSettings().traits.size();
            List<String> childDiscoveries = this.databank.getChildDiscoveries(celestialTarget.getID());
            PlanetTrait trait = this.galaxyMapContext.getDiscoveryFactory().getNextTrait(celestialTarget, childDiscoveries);
            if (trait != null) {
                if (this.galaxyMapContext.getDiscoveryDAO().childDiscoveryExists(target.discovery.id, trait.icon)) {
                    throw new AstraXException(AstraXException.ErrorCode.E3002, trait.icon + "; was this trait properly added to the Discovery System?");
                }
                target.discovery.description = childDiscoveries == null || childDiscoveries.isEmpty() ? trait.description : target.discovery.description + "\n" + trait.description;
                this.logger.finest("Trait target icon: " + trait.targetIcon);
                this.logger.finest("Discovery target icon: " + target.discovery.icon);
                if (trait.targetIcon != null) {
                    target.discovery.icon = trait.targetIcon;
                }
                this.databank.addChildDiscovery(target.target.getID(), trait.id);
                this.galaxyMapContext.getDiscoveryDAO().update(target.discovery);
                this.galaxyMapContext.getDiscoveryDAO().addChildDiscoveryTo(target.discovery.id, trait.id);
                childDiscoveries = this.databank.getChildDiscoveries(celestialTarget.getID());
                target.discovery.discoveredFactor = childDiscoveries != null ? (float)childDiscoveries.size() / (float)allTraits : 0.0f;
                Discovery traitDiscovery = this.galaxyMapContext.getDiscoveryDAO().getByEntityId(trait.id);
                if (traitDiscovery == null) {
                    this.logger.log(Level.INFO, "Discovered a new trait: " + trait.id);
                    traitDiscovery = this.galaxyMapContext.getDiscoveryFactory().createDiscovery(trait);
                    this.galaxyMapContext.getDiscoveryDAO().insert(traitDiscovery);
                }
                for (DiscoveryListener listener : this.discoveryListeners) {
                    listener.onSubDiscovery(target, trait, traitDiscovery);
                }
            }
        } else if (target.target instanceof SatelliteTarget) {
            if (target.discovery == null) {
                // empty if block
            }
            SatelliteTarget satelliteTarget = (SatelliteTarget)target.target;
            target.discovery.icon = ((Satellite)satelliteTarget.getModel()).getSatelliteGrid().vesselSize.getIcon();
            this.galaxyMapContext.getDiscoveryDAO().update(target.discovery);
        }
    }
}

