/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting;

import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.EntityID;
import com.neutronio.astrax.app.datapack.game.DiscoveryTarget;
import com.neutronio.astrax.app.datapack.game.mechanics.discovery.DiscoveryListener;
import com.neutronio.astrax.app.datapack.game.world.Discovery;
import com.neutronio.astrax.app.datapack.game.world.SatelliteTarget;
import com.neutronio.astrax.app.datapack.game.world.Targetable;
import com.neutronio.astrax.app.datapack.game.world.galaxy.SectorStream;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.FunctionalSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors.ProximitySensor;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors.Sonar;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors.SonarListener;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors.TargetSorter;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.DiscoveryDatabank;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.DiscoveryScanner;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.NavigationBookmark;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.TargetComputer;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.TargetComputerListener;
import com.neutronio.astrax.ui.game.menu.StarMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DiscoverySystem
extends FunctionalSystem<Satellite>
implements SonarListener,
TargetComputerListener,
DiscoveryListener {
    private TargetComputer targetComputer = new TargetComputer();
    private DiscoveryDatabank databank = new DiscoveryDatabank();
    private DiscoveryScanner scanner = new DiscoveryScanner(this.databank);
    private DiscoveryTarget self;
    private Sonar sonar;
    private ProximitySensor proximitySensor = new ProximitySensor();
    private DefaultDiscoverySystemListener listener;

    public DiscoverySystem(String displayName, Satellite parent) {
        super(displayName, parent);
        this.sonar = new Sonar(this.proximitySensor);
        this.sonar.addListener(this);
        this.targetComputer.addListener(this);
        this.scanner.addDiscoveryListener(this);
    }

    public void initialize(SectorStream.DiscoveryInfo discoveryInfo) {
        this.initWithDiscoveries(discoveryInfo.discoveryTargets);
        this.getDatabank().setChildDiscoveries(discoveryInfo.childDiscoveries);
    }

    public void initBookmarks(Map<String, NavigationBookmark> bookmarks) {
        for (NavigationBookmark navigationBookmark : bookmarks.values()) {
            this.targetComputer.addNavigationBookmark(navigationBookmark);
            DiscoveryTarget discovery = this.getDatabank().getDiscoveryOf(new EntityID(navigationBookmark.entityId));
            if (discovery == null) continue;
            discovery.bookmark = navigationBookmark;
        }
    }

    private void initWithDiscoveries(List<DiscoveryTarget> discoveries) {
        this.databank.initWithDiscoveries(discoveries);
        this.proximitySensor.setTargets(discoveries);
        this.proximitySensor.calculateTargetInformation();
    }

    public void addDiscoveryTarget(DiscoveryTarget target) {
        this.databank.addDiscovery(target);
        this.proximitySensor.addTarget(target);
    }

    public void synchronizeBookmarks() {
        for (Map.Entry<EntityID, NavigationBookmark> entry : this.targetComputer.getNavigationBookmarks().entrySet()) {
            DiscoveryTarget discovery = this.getDatabank().getDiscoveryOf(entry.getKey());
            if (discovery == null) continue;
            discovery.bookmark = entry.getValue();
        }
    }

    public DiscoveryTarget getSelf() {
        return this.self;
    }

    public void setParentTarget(SatelliteTarget parentTarget) {
        this.proximitySensor.setParentTarget(parentTarget);
        this.targetComputer.setParentTarget(parentTarget);
    }

    public void addBookmark(NavigationBookmark bookmark) {
        DiscoveryTarget discovery = this.getDatabank().getDiscoveryOf(new EntityID(bookmark.entityId));
        if (discovery != null) {
            discovery.bookmark = bookmark;
        }
        this.targetComputer.addNavigationBookmark(bookmark);
    }

    public void removeBookmark(NavigationBookmark bookmark) {
        DiscoveryTarget discovery = this.getDatabank().getDiscoveryOf(new EntityID(bookmark.entityId));
        if (discovery != null) {
            discovery.bookmark = null;
        }
        this.targetComputer.getBookmarkSensor().removeTarget(new EntityID("bookmark_" + bookmark.entityId));
        this.targetComputer.removeNavigationBookmark(bookmark);
    }

    public boolean scanTarget(DiscoveryTarget target) {
        if (this.getProximitySensor().isInScannerRange((Targetable)target.target)) {
            this.getScanner().scanTarget(this.getProximitySensor(), target);
            return true;
        }
        return false;
    }

    public boolean scanSelf(DiscoveryTarget target) {
        if (Objects.equals(target.target.getModel(), this.getParent())) {
            this.self = target;
            this.addDiscoveryTarget(target);
            return true;
        }
        return false;
    }

    public float getDiscoveredFactor() {
        return this.databank.getDiscoveredFactor();
    }

    @Override
    public void update(float delta) {
        this.proximitySensor.update(delta);
        this.targetComputer.update(delta);
        this.sonar.scan();
    }

    public void setListener(DefaultDiscoverySystemListener listener) {
        this.listener = listener;
    }

    public DefaultDiscoverySystemListener getListener() {
        return this.listener;
    }

    public Sonar getSonar() {
        return this.sonar;
    }

    public void setSonar(Sonar sonar) {
        this.sonar = sonar;
    }

    public ProximitySensor getProximitySensor() {
        return this.proximitySensor;
    }

    public void setProximitySensor(ProximitySensor proximitySensor) {
        this.proximitySensor = proximitySensor;
    }

    public TargetComputer getTargetComputer() {
        return this.targetComputer;
    }

    public void setTargetComputer(TargetComputer targetComputer) {
        this.targetComputer = targetComputer;
    }

    public DiscoveryDatabank getDatabank() {
        return this.databank;
    }

    public void setDatabank(DiscoveryDatabank databank) {
        this.databank = databank;
    }

    public DiscoveryScanner getScanner() {
        return this.scanner;
    }

    public void setScanner(DiscoveryScanner scanner) {
        this.scanner = scanner;
    }

    @Override
    public void onTargetDetected(TargetSorter.Target target) {
        AstraXApp.astraX.getUiSoundManager().playSoundOnce("sonar");
        if (this.getListener() != null) {
            this.getListener().onTargetDetected(target);
        }
    }

    @Override
    public void onTargetLost(TargetSorter.Target target) {
        AstraXApp.astraX.getUiSoundManager().playSoundOnce("sonar:loss");
        if (this.getListener() != null) {
            this.getListener().onTargetLost(target);
        }
    }

    @Override
    public void onTargetChanged(DiscoveryTarget oldTarget, DiscoveryTarget newTarget, Class source) {
        boolean fromStarMap = source.equals(StarMap.class);
        if (!fromStarMap) {
            AstraXApp.astraX.getUiSoundManager().playSoundOnce("retract");
        }
        if (this.getListener() != null) {
            this.getListener().onTargetChanged(oldTarget, newTarget, source);
        }
    }

    @Override
    public void onDiscovery(DiscoveryTarget discovery) {
        AstraXApp.astraX.getUiSoundManager().playSoundOnce("msi_new_planet_discovered");
        if (this.getListener() != null) {
            this.getListener().onDiscoveryAdded(discovery);
        }
    }

    @Override
    public void onSubDiscovery(DiscoveryTarget parentDiscovery, Object discoveredObject, Discovery discovery) {
        AstraXApp.astraX.getUiSoundManager().playSoundOnce("chime");
        if (this.getListener() != null) {
            this.getListener().onSubDiscoveryAdded(parentDiscovery, discoveredObject, discovery);
        }
    }

    public static abstract class DefaultDiscoverySystemListener
    implements DiscoverySystemListener,
    SonarListener,
    TargetComputerListener {
    }

    public static interface DiscoverySystemListener {
        public void onDiscoveryAdded(DiscoveryTarget var1);

        public void onSubDiscoveryAdded(DiscoveryTarget var1, Object var2, Discovery var3);
    }
}

