/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting;

import com.neutronio.astrax.app.datapack.EntityID;
import com.neutronio.astrax.app.datapack.game.DiscoveryTarget;
import com.neutronio.astrax.app.datapack.game.world.NavTarget;
import com.neutronio.astrax.app.datapack.game.world.SatelliteTarget;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.sensors.ProximitySensor;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.NavigationBookmark;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.targeting.TargetComputerListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TargetComputer {
    int maxTargets;
    private DiscoveryTarget currentTarget;
    private NavigationBookmark currentBookmark;
    private Map<EntityID, NavigationBookmark> bookmarks = new LinkedHashMap<EntityID, NavigationBookmark>();
    private ProximitySensor bookmarkSensor;
    private List<TargetComputerListener> listeners = new ArrayList<TargetComputerListener>();

    public TargetComputer() {
        this.bookmarkSensor = new ProximitySensor();
        this.bookmarkSensor.setDistanceFilter(null);
    }

    public void setNavigationBookmarks(List<NavigationBookmark> bookmarks) {
        this.bookmarks.clear();
        this.addNavigationBookmarks(bookmarks);
    }

    public void setParentTarget(SatelliteTarget parentTarget) {
        this.bookmarkSensor.setParentTarget(parentTarget);
    }

    public void pinTarget(NavTarget navTarget) {
        DiscoveryTarget<NavTarget> discoveryTarget = new DiscoveryTarget<NavTarget>(null, navTarget);
        this.bookmarkSensor.addTarget(discoveryTarget);
        this.bookmarkSensor.calculateTargetInformation();
    }

    public void unpinTarget(DiscoveryTarget discoveryTarget) {
        this.bookmarkSensor.removeTarget(discoveryTarget);
        this.bookmarkSensor.calculateTargetInformation();
    }

    public void addNavigationBookmarks(List<NavigationBookmark> bookmarks) {
        for (NavigationBookmark bookmark : bookmarks) {
            this.bookmarks.put(new EntityID(bookmark.entityId), bookmark);
        }
    }

    public void addNavigationBookmark(NavigationBookmark bookmark) {
        this.bookmarks.put(new EntityID(bookmark.entityId), bookmark);
    }

    public void removeNavigationBookmark(NavigationBookmark bookmark) {
        this.bookmarks.remove(new EntityID(bookmark.entityId));
    }

    public ProximitySensor getBookmarkSensor() {
        return this.bookmarkSensor;
    }

    public void setCurrentBookmark(NavigationBookmark currentBookmark) {
        this.currentBookmark = currentBookmark;
    }

    public Map<EntityID, NavigationBookmark> getNavigationBookmarks() {
        return this.bookmarks;
    }

    public DiscoveryTarget getCurrentTarget() {
        return this.currentTarget;
    }

    public void setCurrentTarget(DiscoveryTarget currentTarget, Class source) {
        boolean targetChanged = !Objects.equals(currentTarget, this.currentTarget);
        DiscoveryTarget oldTarget = this.currentTarget;
        if (oldTarget != null) {
            oldTarget.target.deselect();
        }
        this.currentTarget = currentTarget;
        if (this.currentTarget != null) {
            this.currentTarget.target.select();
        }
        if (targetChanged) {
            this.fireOnTargetChanged(oldTarget, currentTarget, source);
        }
    }

    public boolean isTargetSelected(EntityID entityID) {
        return this.currentTarget != null && Objects.equals(this.currentTarget.target.getID(), entityID);
    }

    private void fireOnTargetChanged(DiscoveryTarget oldTarget, DiscoveryTarget newTarget, Class source) {
        for (TargetComputerListener listener : this.listeners) {
            listener.onTargetChanged(oldTarget, newTarget, source);
        }
    }

    public void addListener(TargetComputerListener listener) {
        if (listener == null) {
            return;
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void update(float delta) {
        this.bookmarkSensor.update(delta);
    }
}

