/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.trade;

import com.neutronio.astrax.app.datapack.game.Trader;
import com.neutronio.astrax.app.datapack.game.mechanics.resources.Resource;
import com.neutronio.astrax.app.datapack.game.world.NPCTrader;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.FunctionalSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.CargoSystem;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.Cargobay;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.cargo.Item;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.trade.MarketPlace;
import java.util.ArrayList;
import java.util.List;

public class TradeSystem
extends FunctionalSystem<Satellite> {
    private transient Trader trader;
    private transient CargoSystem cargoSystem;
    private MarketPlace marketPlace;
    private List<MarketPlace> marketPlaces = new ArrayList<MarketPlace>();

    public TradeSystem(String displayName, Satellite parent) {
        super(displayName, parent);
        this.cargoSystem = parent.getSystem(CargoSystem.class);
    }

    public void addMarketPlace(MarketPlace marketPlace) {
        this.marketPlaces.add(marketPlace);
    }

    public MarketPlace getMarketPlace(int index) {
        return this.marketPlaces.get(index);
    }

    public Trader getTrader() {
        return this.trader;
    }

    public CargoSystem getCargoSystem() {
        return this.cargoSystem;
    }

    public void setTrader(Trader trader) {
        this.trader = trader;
    }

    public void setCargoSystem(CargoSystem cargoSystem) {
        this.cargoSystem = cargoSystem;
    }

    public void sellTo(TradeSystem merchant, Cargobay<Resource> itemsSoldToMerchant) {
        float tradeValue = itemsSoldToMerchant.getValue();
        List<Item<Resource>> allItems = itemsSoldToMerchant.getAllItems();
        this.cargoSystem.transferTo(merchant.cargoSystem, allItems);
        merchant.trader.changeMoney(-tradeValue);
        this.trader.changeMoney(tradeValue);
        if (merchant.getTrader() instanceof NPCTrader) {
            NPCTrader npcTrader = (NPCTrader)merchant.getTrader();
            for (Item<Resource> item : allItems) {
                npcTrader.getSells().remove(item.getObject(), item.getAmount());
            }
        }
    }

    public void buyFrom(TradeSystem merchant, Cargobay<Resource> itemsBoughtFromMerchant) {
        float tradeValue = itemsBoughtFromMerchant.getValue();
        List<Item<Resource>> allItems = itemsBoughtFromMerchant.getAllItems();
        merchant.cargoSystem.transferTo(this.cargoSystem, allItems);
        merchant.trader.changeMoney(tradeValue);
        this.trader.changeMoney(-tradeValue);
    }

    @Override
    public void update(float delta) {
    }
}

