/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem;

import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.Orbit;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.logging.Logger;

public class EllipsoidOrbit
extends Orbit
implements Serializable {
    private static final long serialVersionUID = 7178494207026437011L;
    private static transient Logger logger = Logger.getLogger(EllipsoidOrbit.class.getCanonicalName());
    protected transient Orbit parent;
    protected float timeOffset = 0.0f;
    protected float velocity = 0.003f;
    protected float width = 200.0f;
    protected float height = 300.0f;
    protected float offsetx = 0.0f;
    protected float offsety = 0.0f;

    public EllipsoidOrbit() {
    }

    public EllipsoidOrbit(float orbitWidth, float orbitHeight) {
        this.width = orbitWidth;
        this.height = orbitHeight;
    }

    public void setParent(Orbit parent) {
        this.parent = parent;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(Float.valueOf(this.width));
        oos.writeObject(Float.valueOf(this.height));
        oos.writeObject(Float.valueOf(this.offsetx));
        oos.writeObject(Float.valueOf(this.offsety));
        oos.writeObject(Float.valueOf(this.velocity));
        oos.writeObject(Float.valueOf(this.timeOffset));
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.width = ois.readFloat();
        this.height = ois.readFloat();
        this.offsetx = ois.readFloat();
        this.offsety = ois.readFloat();
        this.velocity = ois.readFloat();
        this.timeOffset = ois.readFloat();
    }

    public void setTimeOffset(float timeOffset) {
        this.timeOffset = timeOffset;
    }

    public float getVelocity() {
        return this.velocity;
    }

    public void setVelocity(float velocity) {
        this.velocity = velocity;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public void setOffset(float offsetx, float offsety) {
        this.offsetx = offsetx;
        this.offsety = offsety;
    }

    public void setOffsetX(float offsetx) {
        this.offsetx = offsetx;
    }

    public void setOffsetY(float offsety) {
        this.offsety = offsety;
    }

    public float getOffsetX() {
        return this.offsetx;
    }

    public float getOffsetY() {
        return this.offsety;
    }

    @Override
    public float getCurrentY(float starSystemTime) {
        if (this.parent != null) {
            return this.parent.getCurrentY(starSystemTime) + (float)((double)this.height * Math.sin(starSystemTime * this.velocity + this.timeOffset) + (double)this.offsety);
        }
        return (float)((double)this.height * Math.sin(starSystemTime * this.velocity + this.timeOffset) + (double)this.offsety);
    }

    @Override
    public float getCurrentX(float starSystemTime) {
        if (this.parent != null) {
            return this.parent.getCurrentX(starSystemTime) + (float)((double)this.width * Math.cos(starSystemTime * this.velocity + this.timeOffset) + (double)this.offsetx);
        }
        return (float)((double)this.width * Math.cos(starSystemTime * this.velocity + this.timeOffset) + (double)this.offsetx);
    }

    @Override
    public void update(float delta) {
    }
}

