/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem;

import com.neutronio.astrax.app.CreationSettings;

public class OrbitSettings
implements CreationSettings {
    public OrbitType orbitType = OrbitType.ELLIPSOID;
    public float staticPositionX = 0.0f;
    public float staticPositionY = 0.0f;
    public float circleFactor = 0.0f;
    public float offsetX = 0.0f;
    public float offsetY = 0.0f;
    public float minVelocity = 0.003f;
    public float maxVelocity = 0.003f;

    public static OrbitSettings getEllipsoidOrbitSettings(float velocity, float width, float height) {
        OrbitSettings orbitSettings = new OrbitSettings();
        orbitSettings.orbitType = OrbitType.ELLIPSOID;
        orbitSettings.maxVelocity = velocity;
        orbitSettings.minVelocity = velocity * 0.9f;
        return orbitSettings;
    }

    public static OrbitSettings getStaticOrbitSettings(float x, float y) {
        OrbitSettings orbitSettings = new OrbitSettings();
        orbitSettings.orbitType = OrbitType.STATIC;
        orbitSettings.staticPositionX = x;
        orbitSettings.staticPositionY = y;
        orbitSettings.minVelocity = 0.0f;
        orbitSettings.maxVelocity = 0.0f;
        return orbitSettings;
    }

    public String toString() {
        return "OrbitSettings{orbitType=" + (Object)((Object)this.orbitType) + ", staticPositionX=" + this.staticPositionX + ", staticPositionY=" + this.staticPositionY + ", minVelocity=" + this.minVelocity + ", maxVelocity=" + this.maxVelocity + '}';
    }

    public static enum OrbitType {
        STATIC,
        ELLIPSOID;

    }
}

