/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.DataContext;
import com.neutronio.astrax.app.datapack.game.world.AstraXTargetFactory;
import com.neutronio.astrax.app.datapack.game.world.BeltTarget;
import com.neutronio.astrax.app.datapack.game.world.Targetable;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.OrbitalBelt;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.OrbitalBeltSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.starsystem.StaticOrbit;
import com.neutronio.astrax.app.generator.AbstractFactory;
import com.neutronio.astrax.app.generator.Generator;
import com.neutronio.astrax.app.generator.NameSpace;
import com.neutronio.astrax.app.generator.TargetFactory;
import com.neutronio.astrax.app.repository.ResourceRepository;
import com.neutronio.astrax.gfx.OrbitalBeltGraphics;
import com.neutronio.astrax.gfx.factories.OrbitalBeltGraphicsFactory;
import com.neutronio.astrax.util.MathUtil;
import java.util.ArrayList;
import java.util.List;

public class OrbitalBeltFactory
extends AbstractFactory
implements TargetFactory<BeltTarget, OrbitalBeltSettings>,
Generator<OrbitalBelt, OrbitalBeltSettings> {
    private AstraXTargetFactory targetFactory;
    private OrbitalBeltGraphicsFactory orbitalBeltGraphicsFactory;
    private ResourceRepository resourceRepository;

    public OrbitalBeltFactory() {
        this.targetFactory = AstraXApp.astraX.getFactoryByClass(AstraXTargetFactory.class);
    }

    public OrbitalBeltFactory(DataContext dataContext) {
        super(dataContext);
        this.targetFactory = dataContext.getFactory(AstraXTargetFactory.class);
        this.resourceRepository = dataContext.getRepository(ResourceRepository.class);
        this.orbitalBeltGraphicsFactory = dataContext.getFactory(OrbitalBeltGraphicsFactory.class);
    }

    @Override
    public BeltTarget createTarget(OrbitalBeltSettings settings) {
        this.logger.fine("Creating target with current seed " + this.numberGenerator.getSeed());
        OrbitalBelt belt = this.generate(settings);
        OrbitalBeltGraphics beltGraphics = this.orbitalBeltGraphicsFactory.create(settings);
        BeltTarget beltTarget = new BeltTarget(this.entityIDFactory.createID(this.numberGenerator, "belt"), new NameSpace("belt:solid:asteroid"), belt, beltGraphics);
        return beltTarget;
    }

    @Override
    public OrbitalBelt generate(OrbitalBeltSettings orbitalBeltSettings) {
        OrbitalBelt belt = new OrbitalBelt();
        belt.setSettings(orbitalBeltSettings);
        return belt;
    }

    public List<Targetable> generateBeltTargets(OrbitalBeltSettings beltSettings) {
        ArrayList<Targetable> beltTargets = new ArrayList<Targetable>();
        int count = (int)MathUtil.getAsteroidCountByDensity(beltSettings.getDensity(), beltSettings.getOrbitMaxRadius(), beltSettings.getOrbitMinRadius());
        this.logger.fine("Creating belt with " + count + " unique celestial bodies...");
        for (int i2 = 0; i2 < count; ++i2) {
            String asteroidID = this.setGenerator.generate(this.numberGenerator, beltSettings.allowedSubtypes);
            Object settingsObject = this.dataContext.findDataByID(asteroidID);
            TargetFactory factory = this.targetFactory.getFactoryForObject(settingsObject);
            Targetable beltTarget = this.targetFactory.wrapAndCreateTarget(settingsObject, factory);
            beltTargets.add(beltTarget);
        }
        return beltTargets;
    }

    public List<Targetable> populateBelt(BeltTarget target, OrbitalBeltSettings orbitalBeltSettings, int orbitMinRadius, int orbitMaxRadius) {
        this.logger.info("Populating (Asteroid) Belt...");
        orbitalBeltSettings.setOrbitMinRadius(orbitMinRadius);
        orbitalBeltSettings.setOrbitMaxRadius(orbitMaxRadius);
        List<Targetable> beltTargets = this.generateBeltTargets(orbitalBeltSettings);
        for (Targetable beltTarget : beltTargets) {
            Vector2 randomPosition = this.getRandomPointInDisc(orbitMaxRadius, orbitMinRadius);
            beltTarget.setPositionController(new StaticOrbit(randomPosition.x, randomPosition.y));
            ((OrbitalBeltGraphics)target.getGraphics()).addActor((Actor)beltTarget.getGraphics());
            ((OrbitalBelt)target.getModel()).addBeltMember(beltTarget);
        }
        return beltTargets;
    }

    private Vector2 getRandomPointInDisc(float maxradius, float minradius) {
        float randomWidth = this.numberGenerator.getRandomFloat(maxradius, minradius);
        float randomTime = this.numberGenerator.getRandomFloat(360.0f, 0.0f);
        float x = (float)((double)randomWidth * Math.cos(randomTime));
        float y = (float)((double)randomWidth * Math.sin(randomTime));
        return new Vector2(x, y);
    }

    @Override
    public BeltTarget createShuffledTarget(NameSpace nameSpace) {
        return null;
    }
}

